/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.dsl.DownsamplingType;
import org.apache.skywalking.oap.server.core.analysis.meter.ScopeType;

public class ExpressionParsingContext
implements Closeable {
    private static final ThreadLocal<ExpressionParsingContext> CACHE = new ThreadLocal();
    List<String> samples;
    boolean isHistogram;
    int[] percentiles;
    Set<String> aggregationLabels;
    Set<String> scopeLabels;
    DownsamplingType downsampling;
    ScopeType scopeType;

    static ExpressionParsingContext create() {
        if (CACHE.get() == null) {
            CACHE.set(ExpressionParsingContext.builder().samples(Lists.newArrayList()).downsampling(DownsamplingType.AVG).scopeLabels(Sets.newHashSet()).aggregationLabels(Sets.newHashSet()).build());
        }
        return CACHE.get();
    }

    static Optional<ExpressionParsingContext> get() {
        return Optional.ofNullable(CACHE.get());
    }

    public List<String> getLabels() {
        ArrayList<String> result = new ArrayList<String>(this.aggregationLabels);
        result.removeAll(this.scopeLabels);
        return result;
    }

    public void validate(String exp) {
        Preconditions.checkNotNull((Object)this.scopeType, (Object)(exp + ": one of service(), instance() or endpoint() should be invoke"));
    }

    @Override
    public void close() {
        CACHE.remove();
    }

    @Generated
    ExpressionParsingContext(List<String> samples, boolean isHistogram, int[] percentiles, Set<String> aggregationLabels, Set<String> scopeLabels, DownsamplingType downsampling, ScopeType scopeType) {
        this.samples = samples;
        this.isHistogram = isHistogram;
        this.percentiles = percentiles;
        this.aggregationLabels = aggregationLabels;
        this.scopeLabels = scopeLabels;
        this.downsampling = downsampling;
        this.scopeType = scopeType;
    }

    @Generated
    public static ExpressionParsingContextBuilder builder() {
        return new ExpressionParsingContextBuilder();
    }

    @Generated
    public List<String> getSamples() {
        return this.samples;
    }

    @Generated
    public boolean isHistogram() {
        return this.isHistogram;
    }

    @Generated
    public int[] getPercentiles() {
        return this.percentiles;
    }

    @Generated
    public Set<String> getAggregationLabels() {
        return this.aggregationLabels;
    }

    @Generated
    public Set<String> getScopeLabels() {
        return this.scopeLabels;
    }

    @Generated
    public DownsamplingType getDownsampling() {
        return this.downsampling;
    }

    @Generated
    public ScopeType getScopeType() {
        return this.scopeType;
    }

    @Generated
    public String toString() {
        return "ExpressionParsingContext(samples=" + String.valueOf(this.getSamples()) + ", isHistogram=" + this.isHistogram() + ", percentiles=" + Arrays.toString(this.getPercentiles()) + ", aggregationLabels=" + String.valueOf(this.getAggregationLabels()) + ", scopeLabels=" + String.valueOf(this.getScopeLabels()) + ", downsampling=" + String.valueOf((Object)this.getDownsampling()) + ", scopeType=" + String.valueOf(this.getScopeType()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionParsingContext)) {
            return false;
        }
        ExpressionParsingContext other = (ExpressionParsingContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHistogram() != other.isHistogram()) {
            return false;
        }
        List<String> this$samples = this.getSamples();
        List<String> other$samples = other.getSamples();
        if (this$samples == null ? other$samples != null : !((Object)this$samples).equals(other$samples)) {
            return false;
        }
        if (!Arrays.equals(this.getPercentiles(), other.getPercentiles())) {
            return false;
        }
        Set<String> this$aggregationLabels = this.getAggregationLabels();
        Set<String> other$aggregationLabels = other.getAggregationLabels();
        if (this$aggregationLabels == null ? other$aggregationLabels != null : !((Object)this$aggregationLabels).equals(other$aggregationLabels)) {
            return false;
        }
        Set<String> this$scopeLabels = this.getScopeLabels();
        Set<String> other$scopeLabels = other.getScopeLabels();
        if (this$scopeLabels == null ? other$scopeLabels != null : !((Object)this$scopeLabels).equals(other$scopeLabels)) {
            return false;
        }
        DownsamplingType this$downsampling = this.getDownsampling();
        DownsamplingType other$downsampling = other.getDownsampling();
        if (this$downsampling == null ? other$downsampling != null : !((Object)((Object)this$downsampling)).equals((Object)other$downsampling)) {
            return false;
        }
        ScopeType this$scopeType = this.getScopeType();
        ScopeType other$scopeType = other.getScopeType();
        return !(this$scopeType == null ? other$scopeType != null : !this$scopeType.equals(other$scopeType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExpressionParsingContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHistogram() ? 79 : 97);
        List<String> $samples = this.getSamples();
        result = result * 59 + ($samples == null ? 43 : ((Object)$samples).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPercentiles());
        Set<String> $aggregationLabels = this.getAggregationLabels();
        result = result * 59 + ($aggregationLabels == null ? 43 : ((Object)$aggregationLabels).hashCode());
        Set<String> $scopeLabels = this.getScopeLabels();
        result = result * 59 + ($scopeLabels == null ? 43 : ((Object)$scopeLabels).hashCode());
        DownsamplingType $downsampling = this.getDownsampling();
        result = result * 59 + ($downsampling == null ? 43 : ((Object)((Object)$downsampling)).hashCode());
        ScopeType $scopeType = this.getScopeType();
        result = result * 59 + ($scopeType == null ? 43 : $scopeType.hashCode());
        return result;
    }

    @Generated
    public static class ExpressionParsingContextBuilder {
        @Generated
        private List<String> samples;
        @Generated
        private boolean isHistogram;
        @Generated
        private int[] percentiles;
        @Generated
        private Set<String> aggregationLabels;
        @Generated
        private Set<String> scopeLabels;
        @Generated
        private DownsamplingType downsampling;
        @Generated
        private ScopeType scopeType;

        @Generated
        ExpressionParsingContextBuilder() {
        }

        @Generated
        public ExpressionParsingContextBuilder samples(List<String> samples) {
            this.samples = samples;
            return this;
        }

        @Generated
        public ExpressionParsingContextBuilder isHistogram(boolean isHistogram) {
            this.isHistogram = isHistogram;
            return this;
        }

        @Generated
        public ExpressionParsingContextBuilder percentiles(int[] percentiles) {
            this.percentiles = percentiles;
            return this;
        }

        @Generated
        public ExpressionParsingContextBuilder aggregationLabels(Set<String> aggregationLabels) {
            this.aggregationLabels = aggregationLabels;
            return this;
        }

        @Generated
        public ExpressionParsingContextBuilder scopeLabels(Set<String> scopeLabels) {
            this.scopeLabels = scopeLabels;
            return this;
        }

        @Generated
        public ExpressionParsingContextBuilder downsampling(DownsamplingType downsampling) {
            this.downsampling = downsampling;
            return this;
        }

        @Generated
        public ExpressionParsingContextBuilder scopeType(ScopeType scopeType) {
            this.scopeType = scopeType;
            return this;
        }

        @Generated
        public ExpressionParsingContext build() {
            return new ExpressionParsingContext(this.samples, this.isHistogram, this.percentiles, this.aggregationLabels, this.scopeLabels, this.downsampling, this.scopeType);
        }

        @Generated
        public String toString() {
            return "ExpressionParsingContext.ExpressionParsingContextBuilder(samples=" + String.valueOf(this.samples) + ", isHistogram=" + this.isHistogram + ", percentiles=" + Arrays.toString(this.percentiles) + ", aggregationLabels=" + String.valueOf(this.aggregationLabels) + ", scopeLabels=" + String.valueOf(this.scopeLabels) + ", downsampling=" + String.valueOf((Object)this.downsampling) + ", scopeType=" + String.valueOf(this.scopeType) + ")";
        }
    }
}

