/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.ebpf.provider.handler;

import com.google.gson.JsonObject;
import io.grpc.stub.StreamObserver;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFHostProcessDownstream;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFHostProcessMetadata;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFKubernetesProcessDownstream;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFKubernetesProcessMetadata;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFProcessDownstream;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFProcessEntityMetadata;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFProcessPingPkgList;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFProcessProperties;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFProcessReportList;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFProcessServiceGrpc;
import org.apache.skywalking.apm.network.ebpf.profiling.process.v3.EBPFReportProcessDownstream;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.Process;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceUpdate;
import org.apache.skywalking.oap.server.core.source.ServiceLabel;
import org.apache.skywalking.oap.server.core.source.ServiceMeta;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class EBPFProcessServiceHandler
extends EBPFProcessServiceGrpc.EBPFProcessServiceImplBase
implements GRPCHandler {
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingControl;

    public EBPFProcessServiceHandler(ModuleManager moduleManager) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
    }

    public void reportProcesses(EBPFProcessReportList request, StreamObserver<EBPFReportProcessDownstream> responseObserver) {
        String agentId = request.getEbpfAgentID();
        ArrayList<Tuple2<Process, EBPFProcessDownstream>> processes = new ArrayList<Tuple2<Process, EBPFProcessDownstream>>();
        for (EBPFProcessProperties ebpfProcessProperties : request.getProcessesList()) {
            Tuple2<Process, EBPFProcessDownstream> processData = null;
            if (ebpfProcessProperties.hasHostProcess()) {
                processData = this.prepareReportHostProcess(ebpfProcessProperties.getHostProcess(), agentId);
            } else if (ebpfProcessProperties.hasK8SProcess()) {
                processData = this.prepareReportKubernetesProcess(ebpfProcessProperties.getK8SProcess(), agentId);
            }
            if (processData == null) continue;
            processes.add(processData);
        }
        EBPFReportProcessDownstream.Builder builder = EBPFReportProcessDownstream.newBuilder();
        processes.stream().forEach(e -> {
            this.sourceReceiver.receive((ISource)e._1);
            builder.addProcesses((EBPFProcessDownstream)e._2);
            this.handleServiceLabels(((Process)e._1).getServiceName(), ((Process)e._1).isServiceNormal(), ((Process)e._1).getLabels(), ((Process)e._1).getTimeBucket());
        });
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void keepAlive(EBPFProcessPingPkgList request, StreamObserver<Commands> responseObserver) {
        long timeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute);
        String agentID = request.getEbpfAgentID();
        request.getProcessesList().forEach(p -> {
            EBPFProcessEntityMetadata entity = p.getEntityMetadata();
            String serviceName = this.namingControl.formatServiceName(entity.getServiceName());
            String instanceName = this.namingControl.formatInstanceName(entity.getInstanceName());
            Layer layer = Layer.valueOf((String)entity.getLayer());
            Process processUpdate = new Process();
            processUpdate.setServiceName(serviceName);
            processUpdate.setInstanceName(instanceName);
            processUpdate.setServiceNormal(true);
            processUpdate.setName(entity.getProcessName());
            processUpdate.setLabels((List)entity.getLabelsList());
            processUpdate.setProperties(this.convertProperties(p.getPropertiesList()));
            processUpdate.setProfilingSupportStatus(this.getProfilingSupportStatus(p.getPropertiesList()));
            processUpdate.setTimeBucket(timeBucket);
            processUpdate.setAgentId(agentID);
            this.sourceReceiver.receive((ISource)processUpdate);
            ServiceInstanceUpdate serviceInstanceUpdate = new ServiceInstanceUpdate();
            serviceInstanceUpdate.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (boolean)true));
            serviceInstanceUpdate.setName(instanceName);
            serviceInstanceUpdate.setTimeBucket(timeBucket);
            this.sourceReceiver.receive((ISource)serviceInstanceUpdate);
            ServiceMeta serviceMeta = new ServiceMeta();
            serviceMeta.setName(serviceName);
            serviceMeta.setTimeBucket(timeBucket);
            serviceMeta.setLayer(layer);
            this.sourceReceiver.receive((ISource)serviceMeta);
            this.handleServiceLabels(serviceName, true, processUpdate.getLabels(), timeBucket);
        });
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }

    private Tuple2<Process, EBPFProcessDownstream> prepareReportHostProcess(EBPFHostProcessMetadata hostProcess, String agentId) {
        Process process = new Process();
        process.setServiceName(this.namingControl.formatServiceName(hostProcess.getEntity().getServiceName()));
        process.setServiceNormal(true);
        process.setInstanceName(this.namingControl.formatInstanceName(hostProcess.getEntity().getInstanceName()));
        process.setName(hostProcess.getEntity().getProcessName());
        process.setDetectType(ProcessDetectType.VM);
        process.setAgentId(agentId);
        process.setProperties(this.convertProperties(hostProcess.getPropertiesList()));
        process.setLabels((List)hostProcess.getEntity().getLabelsList());
        process.setProfilingSupportStatus(this.getProfilingSupportStatus(hostProcess.getPropertiesList()));
        process.setTimeBucket(TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute));
        process.prepare();
        String processId = process.getEntityId();
        EBPFProcessDownstream downstream = EBPFProcessDownstream.newBuilder().setProcessId(processId).setHostProcess(EBPFHostProcessDownstream.newBuilder().setPid(hostProcess.getPid()).setEntityMetadata(hostProcess.getEntity()).build()).build();
        return Tuple.of((Object)process, (Object)downstream);
    }

    private Tuple2<Process, EBPFProcessDownstream> prepareReportKubernetesProcess(EBPFKubernetesProcessMetadata kubernetesProcessMetadata, String agentId) {
        Process process = new Process();
        process.setServiceName(this.namingControl.formatServiceName(kubernetesProcessMetadata.getEntity().getServiceName()));
        process.setServiceNormal(true);
        process.setInstanceName(this.namingControl.formatInstanceName(kubernetesProcessMetadata.getEntity().getInstanceName()));
        process.setName(kubernetesProcessMetadata.getEntity().getProcessName());
        process.setDetectType(ProcessDetectType.KUBERNETES);
        process.setAgentId(agentId);
        process.setProperties(this.convertProperties(kubernetesProcessMetadata.getPropertiesList()));
        process.setLabels((List)kubernetesProcessMetadata.getEntity().getLabelsList());
        process.setProfilingSupportStatus(this.getProfilingSupportStatus(kubernetesProcessMetadata.getPropertiesList()));
        process.setTimeBucket(TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute));
        process.prepare();
        String processId = process.getEntityId();
        EBPFProcessDownstream downstream = EBPFProcessDownstream.newBuilder().setProcessId(processId).setK8SProcess(EBPFKubernetesProcessDownstream.newBuilder().setPid(kubernetesProcessMetadata.getPid()).setEntityMetadata(kubernetesProcessMetadata.getEntity()).build()).build();
        return Tuple.of((Object)process, (Object)downstream);
    }

    private void handleServiceLabels(String serviceName, boolean isServiceNormal, List<String> labels, long timeBucket) {
        if (CollectionUtils.isEmpty(labels)) {
            return;
        }
        for (String label : labels) {
            ServiceLabel serviceLabel = new ServiceLabel();
            serviceLabel.setServiceName(serviceName);
            serviceLabel.setServiceNormal(isServiceNormal);
            serviceLabel.setLabel(label);
            serviceLabel.setTimeBucket(timeBucket);
            this.sourceReceiver.receive((ISource)serviceLabel);
        }
    }

    private ProfilingSupportStatus getProfilingSupportStatus(List<KeyStringValuePair> properties) {
        for (KeyStringValuePair property : properties) {
            if (!Objects.equals(property.getKey(), "support_ebpf_profiling") || !Objects.equals(property.getValue(), "true")) continue;
            return ProfilingSupportStatus.SUPPORT_EBPF_PROFILING;
        }
        return ProfilingSupportStatus.NOT_SUPPORT;
    }

    private JsonObject convertProperties(List<KeyStringValuePair> properties) {
        JsonObject result = new JsonObject();
        for (KeyStringValuePair kv : properties) {
            result.addProperty(kv.getKey(), kv.getValue());
        }
        return result;
    }
}

