/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class EBPFProfilingTaskEsDAO
extends EsDAO
implements IEBPFProfilingTaskDAO {
    private final int taskMaxSize;

    public EBPFProfilingTaskEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.taskMaxSize = config.getProfileTaskQueryMaxSize();
    }

    public List<EBPFProfilingTaskRecord> queryTasksByServices(List<String> serviceIdList, EBPFProfilingTriggerType triggerType, long taskStartTime, long latestUpdateTime) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ebpf_profiling_task");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("ebpf_profiling_task")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"ebpf_profiling_task"));
        }
        if (CollectionUtils.isNotEmpty(serviceIdList)) {
            query.must((QueryBuilder)Query.terms((String)"service_id", serviceIdList));
        }
        if (taskStartTime > 0L) {
            query.must((QueryBuilder)Query.range((String)"start_time").gte((Object)taskStartTime));
        }
        if (latestUpdateTime > 0L) {
            query.must((QueryBuilder)Query.range((String)"last_update_time").gt((Object)latestUpdateTime));
        }
        if (triggerType != null) {
            query.must((QueryBuilder)Query.term((String)"trigger_type", (Object)triggerType.value()));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).sort("create_time", Sort.Order.DESC).size(Integer.valueOf(this.taskMaxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return response.getHits().getHits().stream().map(this::parseTask).collect(Collectors.toList());
    }

    public List<EBPFProfilingTaskRecord> queryTasksByTargets(String serviceId, String serviceInstanceId, List<EBPFProfilingTargetType> targetTypes, EBPFProfilingTriggerType triggerType, long taskStartTime, long latestUpdateTime) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ebpf_profiling_task");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("ebpf_profiling_task")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"ebpf_profiling_task"));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            query.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            query.must((QueryBuilder)Query.term((String)"instance_id", (Object)serviceInstanceId));
        }
        if (CollectionUtils.isNotEmpty(targetTypes)) {
            query.must((QueryBuilder)Query.terms((String)"target_type", targetTypes.stream().map(EBPFProfilingTargetType::value).collect(Collectors.toList())));
        }
        if (triggerType != null) {
            query.must((QueryBuilder)Query.term((String)"trigger_type", (Object)triggerType.value()));
        }
        if (taskStartTime > 0L) {
            query.must((QueryBuilder)Query.range((String)"start_time").gte((Object)taskStartTime));
        }
        if (latestUpdateTime > 0L) {
            query.must((QueryBuilder)Query.range((String)"last_update_time").gt((Object)latestUpdateTime));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).sort("create_time", Sort.Order.DESC).size(Integer.valueOf(this.taskMaxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return response.getHits().getHits().stream().map(this::parseTask).collect(Collectors.toList());
    }

    public List<EBPFProfilingTaskRecord> getTaskRecord(String id) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ebpf_profiling_task");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"logical_id", (Object)id));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.taskMaxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return response.getHits().getHits().stream().map(this::parseTask).collect(Collectors.toList());
    }

    private EBPFProfilingTaskRecord parseTask(SearchHit hit) {
        Map sourceAsMap = hit.getSource();
        EBPFProfilingTaskRecord.Builder builder = new EBPFProfilingTaskRecord.Builder();
        return builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("ebpf_profiling_task", sourceAsMap));
    }
}

