/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.tool.profile.exporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileTaskQueryService;
import org.apache.skywalking.oap.server.core.query.TraceQueryService;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.Trace;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.tool.profile.exporter.ExporterConfig;
import org.yaml.snakeyaml.Yaml;

public class ProfiledBasicInfo {
    public static final int SEQUENCE_RANGE_BATCH_SIZE = 500;
    private ExporterConfig config;
    private List<ProfiledSegment> segments;
    private List<Span> profiledSegmentSpans;

    public static ProfiledBasicInfo build(ExporterConfig config, ModuleManager manager) throws IOException {
        ProfiledBasicInfo data = new ProfiledBasicInfo();
        data.setConfig(config);
        ProfileTaskQueryService taskQueryService = (ProfileTaskQueryService)manager.find("core").provider().getService(ProfileTaskQueryService.class);
        TraceQueryService traceQueryService = (TraceQueryService)manager.find("core").provider().getService(TraceQueryService.class);
        IProfileThreadSnapshotQueryDAO threadSnapshotQueryDAO = (IProfileThreadSnapshotQueryDAO)manager.find("storage").provider().getService(IProfileThreadSnapshotQueryDAO.class);
        List taskTraces = taskQueryService.getTaskSegments(config.getTaskId());
        List segments = taskTraces.stream().filter(t -> Objects.equals(t.getTraceId(), config.getTraceId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(segments)) {
            throw new IllegalArgumentException("Cannot fount profiled segment in current task: " + config.getTaskId() + ", segment id: " + config.getTraceId() + ", current task total profiled trace count is " + taskTraces.size());
        }
        data.setSegments(new ArrayList<ProfiledSegment>());
        data.setProfiledSegmentSpans(new ArrayList<Span>());
        for (SegmentRecord segment : segments) {
            ProfiledSegment profiledSegment = new ProfiledSegment();
            String segmentId = segment.getSegmentId();
            long startTime = segment.getStartTime();
            long endTime = startTime + (long)segment.getLatency();
            profiledSegment.setSegmentId(segmentId);
            profiledSegment.setSegmentStartTime(startTime);
            profiledSegment.setSegmentEndTime(endTime);
            profiledSegment.setDuration(segment.getLatency());
            Trace trace = traceQueryService.queryTrace(config.getTraceId(), null);
            List profiledSegmentSpans = trace.getSpans().stream().filter(s -> Objects.equals(s.getSegmentId(), segmentId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(profiledSegmentSpans)) {
                throw new IllegalArgumentException("Current segment cannot found any span");
            }
            data.getProfiledSegmentSpans().addAll(profiledSegmentSpans);
            int minSequence = threadSnapshotQueryDAO.queryMinSequence(segmentId, startTime, endTime);
            int maxSequence = threadSnapshotQueryDAO.queryMaxSequence(segmentId, startTime, endTime);
            profiledSegment.setMinSequence(minSequence);
            profiledSegment.setMaxSequence(maxSequence);
            data.getSegments().add(profiledSegment);
        }
        return data;
    }

    public File writeFile() throws IOException {
        String serialData = new Yaml().dump((Object)this);
        File file = new File(this.config.getAnalyzeResultDist() + File.separator + "basic.yml");
        FileUtils.write((File)file, (CharSequence)serialData, (String)"UTF-8");
        return file;
    }

    public static ProfiledBasicInfo parseFormFile(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ProfiledBasicInfo profiledBasicInfo = (ProfiledBasicInfo)new Yaml().loadAs((InputStream)fileInputStream, ProfiledBasicInfo.class);
            return profiledBasicInfo;
        }
    }

    public List<SequenceRange> buildSequenceRanges() {
        ArrayList<SequenceRange> ranges = new ArrayList<SequenceRange>();
        for (ProfiledSegment segment : this.segments) {
            int batchMax;
            int minSequence = segment.minSequence;
            do {
                batchMax = Math.min(minSequence + 500, segment.maxSequence);
                ranges.add(new SequenceRange(segment.getSegmentId(), minSequence, batchMax));
            } while ((minSequence = batchMax) < segment.maxSequence);
        }
        return ranges;
    }

    @Generated
    public ProfiledBasicInfo() {
    }

    @Generated
    public ExporterConfig getConfig() {
        return this.config;
    }

    @Generated
    public List<ProfiledSegment> getSegments() {
        return this.segments;
    }

    @Generated
    public List<Span> getProfiledSegmentSpans() {
        return this.profiledSegmentSpans;
    }

    @Generated
    public void setConfig(ExporterConfig config) {
        this.config = config;
    }

    @Generated
    public void setSegments(List<ProfiledSegment> segments) {
        this.segments = segments;
    }

    @Generated
    public void setProfiledSegmentSpans(List<Span> profiledSegmentSpans) {
        this.profiledSegmentSpans = profiledSegmentSpans;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfiledBasicInfo)) {
            return false;
        }
        ProfiledBasicInfo other = (ProfiledBasicInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExporterConfig this$config = this.getConfig();
        ExporterConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        List<ProfiledSegment> this$segments = this.getSegments();
        List<ProfiledSegment> other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
            return false;
        }
        List<Span> this$profiledSegmentSpans = this.getProfiledSegmentSpans();
        List<Span> other$profiledSegmentSpans = other.getProfiledSegmentSpans();
        return !(this$profiledSegmentSpans == null ? other$profiledSegmentSpans != null : !((Object)this$profiledSegmentSpans).equals(other$profiledSegmentSpans));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProfiledBasicInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExporterConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        List<ProfiledSegment> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        List<Span> $profiledSegmentSpans = this.getProfiledSegmentSpans();
        result = result * 59 + ($profiledSegmentSpans == null ? 43 : ((Object)$profiledSegmentSpans).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProfiledBasicInfo(config=" + String.valueOf(this.getConfig()) + ", segments=" + String.valueOf(this.getSegments()) + ", profiledSegmentSpans=" + String.valueOf(this.getProfiledSegmentSpans()) + ")";
    }

    public static class ProfiledSegment {
        private String segmentId;
        private long segmentStartTime;
        private long segmentEndTime;
        private int duration;
        private int minSequence;
        private int maxSequence;

        @Generated
        public ProfiledSegment() {
        }

        @Generated
        public String getSegmentId() {
            return this.segmentId;
        }

        @Generated
        public long getSegmentStartTime() {
            return this.segmentStartTime;
        }

        @Generated
        public long getSegmentEndTime() {
            return this.segmentEndTime;
        }

        @Generated
        public int getDuration() {
            return this.duration;
        }

        @Generated
        public int getMinSequence() {
            return this.minSequence;
        }

        @Generated
        public int getMaxSequence() {
            return this.maxSequence;
        }

        @Generated
        public void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Generated
        public void setSegmentStartTime(long segmentStartTime) {
            this.segmentStartTime = segmentStartTime;
        }

        @Generated
        public void setSegmentEndTime(long segmentEndTime) {
            this.segmentEndTime = segmentEndTime;
        }

        @Generated
        public void setDuration(int duration) {
            this.duration = duration;
        }

        @Generated
        public void setMinSequence(int minSequence) {
            this.minSequence = minSequence;
        }

        @Generated
        public void setMaxSequence(int maxSequence) {
            this.maxSequence = maxSequence;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProfiledSegment)) {
                return false;
            }
            ProfiledSegment other = (ProfiledSegment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSegmentStartTime() != other.getSegmentStartTime()) {
                return false;
            }
            if (this.getSegmentEndTime() != other.getSegmentEndTime()) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            if (this.getMinSequence() != other.getMinSequence()) {
                return false;
            }
            if (this.getMaxSequence() != other.getMaxSequence()) {
                return false;
            }
            String this$segmentId = this.getSegmentId();
            String other$segmentId = other.getSegmentId();
            return !(this$segmentId == null ? other$segmentId != null : !this$segmentId.equals(other$segmentId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProfiledSegment;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $segmentStartTime = this.getSegmentStartTime();
            result = result * 59 + (int)($segmentStartTime >>> 32 ^ $segmentStartTime);
            long $segmentEndTime = this.getSegmentEndTime();
            result = result * 59 + (int)($segmentEndTime >>> 32 ^ $segmentEndTime);
            result = result * 59 + this.getDuration();
            result = result * 59 + this.getMinSequence();
            result = result * 59 + this.getMaxSequence();
            String $segmentId = this.getSegmentId();
            result = result * 59 + ($segmentId == null ? 43 : $segmentId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProfiledBasicInfo.ProfiledSegment(segmentId=" + this.getSegmentId() + ", segmentStartTime=" + this.getSegmentStartTime() + ", segmentEndTime=" + this.getSegmentEndTime() + ", duration=" + this.getDuration() + ", minSequence=" + this.getMinSequence() + ", maxSequence=" + this.getMaxSequence() + ")";
        }
    }

    public static class SequenceRange {
        private String segmentId;
        private int min;
        private int max;

        public SequenceRange(String segmentId, int min, int max) {
            this.segmentId = segmentId;
            this.min = min;
            this.max = max;
        }

        @Generated
        public String getSegmentId() {
            return this.segmentId;
        }

        @Generated
        public int getMin() {
            return this.min;
        }

        @Generated
        public int getMax() {
            return this.max;
        }
    }
}

