/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.query.type.trace.v2.TracesQueryResult;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.proto.SpanWrapper;

public interface ITraceQueryV2DAO
extends ITraceQueryDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public TracesQueryResult queryTracesDebuggable(TraceQueryCondition condition) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            StringBuilder builder = new StringBuilder();
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: queryTraces");
                builder.append("Condition: TraceQueryCondition: ").append(condition);
                span.setMsg(builder.toString());
            }
            TracesQueryResult tracesQueryResult = this.queryTraces(condition);
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            return tracesQueryResult;
        }
        catch (Throwable throwable) {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            throw throwable;
        }
    }

    public List<SpanWrapper> queryByTraceIdV2(String var1, @Nullable Duration var2) throws IOException;

    public TracesQueryResult queryTraces(TraceQueryCondition var1) throws IOException;
}

