/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.type.PprofTask;
import org.apache.skywalking.oap.server.library.module.Service;

public class PprofTaskCache
implements Service {
    private final Cache<String, List<PprofTask>> serviceId2taskCache;

    public PprofTaskCache(CoreModuleConfig moduleConfig) {
        long initialSize = moduleConfig.getMaxSizeOfPprofTask() / 10L;
        int initialCapacitySize = (int)(initialSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : initialSize);
        this.serviceId2taskCache = CacheBuilder.newBuilder().initialCapacity(initialCapacitySize).maximumSize(moduleConfig.getMaxSizeOfProfileTask()).expireAfterWrite(Duration.ofMinutes(1L)).build();
    }

    public List<PprofTask> getPprofTaskList(String serviceId) {
        List pprofTaskList = (List)this.serviceId2taskCache.getIfPresent((Object)serviceId);
        return pprofTaskList;
    }

    public void saveTaskList(String serviceId, List<PprofTask> taskList) {
        if (taskList == null) {
            taskList = Collections.emptyList();
        }
        this.serviceId2taskCache.put((Object)serviceId, taskList);
    }

    public long getCacheStartTimeBucket() {
        return TimeBucket.getRecordTimeBucket(System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L));
    }

    public long getCacheEndTimeBucket() {
        return TimeBucket.getRecordTimeBucket(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L));
    }
}

