/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.relation.endpoint;

import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.endpoint.EndpointRelationServerSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.EndpointRelation;

public class EndpointCallRelationDispatcher
implements SourceDispatcher<EndpointRelation> {
    @Override
    public void dispatch(EndpointRelation source) {
        switch (source.getDetectPoint()) {
            case SERVER: {
                this.serverSide(source);
                break;
            }
        }
    }

    private void serverSide(EndpointRelation source) {
        EndpointRelationServerSideMetrics metrics = new EndpointRelationServerSideMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setSourceEndpoint(IDManager.EndpointID.buildId(source.getServiceId(), source.getEndpoint()));
        metrics.setDestEndpoint(IDManager.EndpointID.buildId(source.getChildServiceId(), source.getChildEndpoint()));
        metrics.setComponentId(source.getComponentId());
        metrics.setEntityId(source.getEntityId());
        MetricsStreamProcessor.getInstance().in(metrics);
    }
}

