/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerConfig;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerListener;
import com.linecorp.armeria.client.circuitbreaker.CircuitState;
import com.linecorp.armeria.client.circuitbreaker.EventCount;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.circuitbreaker.CircuitBreakerCallback;
import com.linecorp.armeria.common.util.EventCounter;
import com.linecorp.armeria.common.util.Ticker;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NonBlockingCircuitBreaker
implements CircuitBreaker,
CircuitBreakerCallback {
    private static final Logger logger = LoggerFactory.getLogger(NonBlockingCircuitBreaker.class);
    private static final AtomicLong seqNo = new AtomicLong(0L);
    private final String name;
    private final CircuitBreakerConfig config;
    private final AtomicReference<State> state;
    private final Ticker ticker;

    NonBlockingCircuitBreaker(Ticker ticker, CircuitBreakerConfig config) {
        this.ticker = Objects.requireNonNull(ticker, "ticker");
        this.config = Objects.requireNonNull(config, "config");
        String name = config.name();
        this.name = name != null ? name : "circuit-breaker-" + seqNo.getAndIncrement();
        this.state = new AtomicReference<State>(this.newClosedState());
        this.logStateTransition(CircuitState.CLOSED, null);
        this.notifyInitialized();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void onSuccess() {
        State currentState = this.state();
        if (currentState.isClosed()) {
            com.linecorp.armeria.common.util.EventCount updatedCount = currentState.counter().onSuccess();
            if (updatedCount != null) {
                this.notifyCountUpdated(updatedCount);
            }
        } else if (currentState.isHalfOpen() && this.state.compareAndSet(currentState, this.newClosedState())) {
            this.logStateTransition(CircuitState.CLOSED, null);
            this.notifyStateChanged(CircuitState.CLOSED);
        }
    }

    @Override
    public void onSuccess(RequestContext ctx) {
        this.onSuccess();
    }

    @Override
    public void onFailure() {
        State currentState = this.state();
        if (currentState.isClosed()) {
            com.linecorp.armeria.common.util.EventCount updatedCount = currentState.counter().onFailure();
            if (updatedCount != null) {
                if (this.checkIfExceedingFailureThreshold(updatedCount) && this.state.compareAndSet(currentState, this.newOpenState())) {
                    this.logStateTransition(CircuitState.OPEN, updatedCount);
                    this.notifyStateChanged(CircuitState.OPEN);
                } else {
                    this.notifyCountUpdated(updatedCount);
                }
            }
        } else if (currentState.isHalfOpen() && this.state.compareAndSet(currentState, this.newOpenState())) {
            this.logStateTransition(CircuitState.OPEN, null);
            this.notifyStateChanged(CircuitState.OPEN);
        }
    }

    @Override
    public void onFailure(RequestContext ctx, @Nullable Throwable throwable) {
        this.onFailure();
    }

    private boolean checkIfExceedingFailureThreshold(com.linecorp.armeria.common.util.EventCount count) {
        return 0L < count.total() && this.config.minimumRequestThreshold() <= count.total() && this.config.failureRateThreshold() < count.failureRate();
    }

    @Override
    @Deprecated
    public boolean canRequest() {
        return this.tryRequest();
    }

    @Override
    public boolean tryRequest() {
        State currentState = this.state();
        if (currentState.isClosed()) {
            return true;
        }
        if (currentState.isForcedOpen()) {
            this.notifyRequestRejected();
            return false;
        }
        if (currentState.isHalfOpen() || currentState.isOpen()) {
            if (currentState.checkTimeout() && this.state.compareAndSet(currentState, this.newHalfOpenState())) {
                this.logStateTransition(CircuitState.HALF_OPEN, null);
                this.notifyStateChanged(CircuitState.HALF_OPEN);
                return true;
            }
            this.notifyRequestRejected();
            return false;
        }
        return true;
    }

    @Override
    public CircuitState circuitState() {
        return this.state().circuitState;
    }

    @Override
    public void enterState(CircuitState circuitState) {
        Objects.requireNonNull(circuitState, "circuitState");
        State oldState = this.state.getAndUpdate(st -> this.newState(circuitState));
        if (oldState.circuitState() == circuitState) {
            return;
        }
        this.logStateTransition(circuitState, null);
        this.notifyStateChanged(circuitState);
    }

    private State newOpenState() {
        return new State(CircuitState.OPEN, this.config.circuitOpenWindow(), NoOpCounter.INSTANCE);
    }

    private State newHalfOpenState() {
        return new State(CircuitState.HALF_OPEN, this.config.trialRequestInterval(), NoOpCounter.INSTANCE);
    }

    private State newClosedState() {
        return new State(CircuitState.CLOSED, Duration.ZERO, EventCounter.ofSlidingWindow(this.ticker, this.config.counterSlidingWindow(), this.config.counterUpdateInterval()));
    }

    private State newForcedOpenState() {
        return new State(CircuitState.FORCED_OPEN, Duration.ZERO, NoOpCounter.INSTANCE);
    }

    private void logStateTransition(CircuitState circuitState, @Nullable com.linecorp.armeria.common.util.EventCount count) {
        if (logger.isInfoEnabled()) {
            int capacity = this.name.length() + circuitState.name().length() + 32;
            StringBuilder builder = new StringBuilder(capacity);
            builder.append("name:");
            builder.append(this.name);
            builder.append(" state:");
            builder.append(circuitState.name());
            if (count != null) {
                builder.append(" fail:");
                builder.append(count.failure());
                builder.append(" total:");
                builder.append(count.total());
            }
            logger.info(builder.toString());
        }
    }

    private void notifyInitialized() {
        this.config.listeners().forEach(listener -> {
            try {
                listener.onInitialized(this.name(), CircuitState.CLOSED);
            }
            catch (Throwable t) {
                logger.warn("An error occurred when notifying an Initialized event", t);
            }
            this.notifyCountUpdated((CircuitBreakerListener)listener, com.linecorp.armeria.common.util.EventCount.ZERO);
        });
    }

    private void notifyStateChanged(CircuitState circuitState) {
        this.config.listeners().forEach(listener -> {
            try {
                listener.onStateChanged(this.name(), circuitState);
            }
            catch (Throwable t) {
                logger.warn("An error occurred when notifying a StateChanged event", t);
            }
            this.notifyCountUpdated((CircuitBreakerListener)listener, com.linecorp.armeria.common.util.EventCount.ZERO);
        });
    }

    private void notifyCountUpdated(com.linecorp.armeria.common.util.EventCount count) {
        this.config.listeners().forEach(listener -> this.notifyCountUpdated((CircuitBreakerListener)listener, count));
    }

    private void notifyCountUpdated(CircuitBreakerListener listener, com.linecorp.armeria.common.util.EventCount count) {
        try {
            String name = this.name();
            listener.onEventCountUpdated(name, count);
            listener.onEventCountUpdated(name, EventCount.of(count.success(), count.failure()));
        }
        catch (Throwable t) {
            logger.warn("An error occurred when notifying an EventCountUpdated event", t);
        }
    }

    private void notifyRequestRejected() {
        this.config.listeners().forEach(listener -> {
            try {
                listener.onRequestRejected(this.name());
            }
            catch (Throwable t) {
                logger.warn("An error occurred when notifying a RequestRejected event", t);
            }
        });
    }

    State state() {
        State state = this.state.get();
        assert (state != null);
        return state;
    }

    CircuitBreakerConfig config() {
        return this.config;
    }

    private State newState(CircuitState circuitState) {
        switch (circuitState) {
            case OPEN: {
                return this.newOpenState();
            }
            case HALF_OPEN: {
                return this.newHalfOpenState();
            }
            case CLOSED: {
                return this.newClosedState();
            }
            case FORCED_OPEN: {
                return this.newForcedOpenState();
            }
        }
        throw new Error();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("config", this.config).toString();
    }

    final class State {
        private final CircuitState circuitState;
        private final EventCounter counter;
        private final long timedOutTimeNanos;

        private State(CircuitState circuitState, Duration timeoutDuration, EventCounter counter) {
            this.circuitState = circuitState;
            this.counter = counter;
            this.timedOutTimeNanos = timeoutDuration.isZero() || timeoutDuration.isNegative() ? 0L : NonBlockingCircuitBreaker.this.ticker.read() + timeoutDuration.toNanos();
        }

        private EventCounter counter() {
            return this.counter;
        }

        private boolean checkTimeout() {
            return 0L < this.timedOutTimeNanos && this.timedOutTimeNanos <= NonBlockingCircuitBreaker.this.ticker.read();
        }

        boolean isOpen() {
            return this.circuitState == CircuitState.OPEN;
        }

        boolean isHalfOpen() {
            return this.circuitState == CircuitState.HALF_OPEN;
        }

        boolean isClosed() {
            return this.circuitState == CircuitState.CLOSED;
        }

        boolean isForcedOpen() {
            return this.circuitState == CircuitState.FORCED_OPEN;
        }

        CircuitState circuitState() {
            return this.circuitState;
        }
    }

    private static class NoOpCounter
    implements EventCounter {
        private static final NoOpCounter INSTANCE = new NoOpCounter();

        private NoOpCounter() {
        }

        @Override
        public com.linecorp.armeria.common.util.EventCount count() {
            return com.linecorp.armeria.common.util.EventCount.ZERO;
        }

        @Override
        @Nullable
        public com.linecorp.armeria.common.util.EventCount onSuccess() {
            return null;
        }

        @Override
        @Nullable
        public com.linecorp.armeria.common.util.EventCount onFailure() {
            return null;
        }
    }
}

