/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1String;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1UniversalType;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERGraphicString;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DEROctetString;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class ASN1GraphicString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1GraphicString.class, 25){

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1GraphicString.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    ASN1GraphicString(byte[] byArray, boolean bl) {
        if (null == byArray) {
            throw new NullPointerException("'contents' cannot be null");
        }
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 25, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GraphicString)) {
            return false;
        }
        ASN1GraphicString aSN1GraphicString = (ASN1GraphicString)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1GraphicString.contents);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    public final String getString() {
        return Strings.fromByteArray(this.contents);
    }

    static ASN1GraphicString createPrimitive(byte[] byArray) {
        return new DERGraphicString(byArray, false);
    }
}

