/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.VirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface RejectedRouteHandler {
    public static final RejectedRouteHandler DISABLED = (virtualHost, route, existingRoute) -> {};
    public static final RejectedRouteHandler WARN = (virtualHost, route, existingRoute) -> {
        Logger logger = LoggerFactory.getLogger(RejectedRouteHandler.class);
        String a = route.toString();
        String b = existingRoute.toString();
        String hostnamePattern = virtualHost.hostnamePattern();
        if (a.equals(b)) {
            logger.warn("Virtual host '{}' has a duplicate route: {}", (Object)hostnamePattern, (Object)a);
        } else {
            logger.warn("Virtual host '{}' has routes with a conflict: {} vs. {}", hostnamePattern, a, b);
        }
    };
    public static final RejectedRouteHandler FAIL = (virtualHost, route, existingRoute) -> {
        String a = route.toString();
        String b = existingRoute.toString();
        String hostnamePattern = virtualHost.hostnamePattern();
        if (a.equals(b)) {
            throw new IllegalStateException("Virtual host '" + hostnamePattern + "' has a duplicate route: " + a);
        }
        throw new IllegalStateException("Virtual host '" + hostnamePattern + "' has routes with a conflict: " + a + " vs. " + b);
    };

    public void handleDuplicateRoute(VirtualHost var1, Route var2, Route var3) throws Exception;
}

