/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.ByteStreamMessage;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InputStreamStreamMessage
implements ByteStreamMessage {
    private static final Logger logger = LoggerFactory.getLogger(InputStreamStreamMessage.class);
    private static final AtomicIntegerFieldUpdater<InputStreamStreamMessage> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(InputStreamStreamMessage.class, "subscribed");
    private final InputStream inputStream;
    @Nullable
    private final ExecutorService blockingTaskExecutor;
    private final int bufferSize;
    private long offset;
    private long length = Long.MAX_VALUE;
    private volatile int subscribed;
    private final CompletableFuture<Void> completionFuture = new EventLoopCheckingFuture<Void>();
    @Nullable
    private volatile InputStreamSubscription inputStreamSubscription;

    InputStreamStreamMessage(InputStream inputStream, @Nullable ExecutorService blockingTaskExecutor, int bufferSize) {
        Objects.requireNonNull(inputStream, "inputStream");
        this.inputStream = inputStream;
        this.blockingTaskExecutor = blockingTaskExecutor;
        this.bufferSize = bufferSize;
    }

    @Override
    public ByteStreamMessage range(long offset, long length) {
        Preconditions.checkArgument(offset >= 0L, "offset: %s (expected: >= 0)", offset);
        Preconditions.checkArgument(length >= 0L, "length: %s (expected: >= 0)", length);
        Preconditions.checkState(this.subscribed == 0, "cannot specify range(%s, %s) once this stream is subscribed", offset, length);
        this.offset = offset;
        this.length = length;
        return this;
    }

    @Override
    public boolean isOpen() {
        return !this.completionFuture.isDone();
    }

    @Override
    public boolean isEmpty() {
        if (this.isOpen()) {
            return false;
        }
        InputStreamSubscription inputStreamSubscription = this.inputStreamSubscription;
        return inputStreamSubscription == null || !inputStreamSubscription.written;
    }

    @Override
    public long demand() {
        InputStreamSubscription inputStreamSubscription = this.inputStreamSubscription;
        if (inputStreamSubscription != null) {
            return inputStreamSubscription.requested;
        }
        return 0L;
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    @Override
    public void subscribe(Subscriber<? super HttpData> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (!subscribedUpdater.compareAndSet(this, 0, 1)) {
            subscriber.onSubscribe(NoopSubscription.get());
            subscriber.onError(new IllegalStateException("Only single subscriber is allowed!"));
            return;
        }
        if (executor.inEventLoop()) {
            this.subscribe0(subscriber, executor, options);
        } else {
            executor.execute(() -> this.subscribe0(subscriber, executor, options));
        }
    }

    private void subscribe0(Subscriber<? super HttpData> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        InputStreamSubscription inputStreamSubscription;
        ServiceRequestContext serviceRequestContext;
        ExecutorService blockingTaskExecutor = this.blockingTaskExecutor != null ? this.blockingTaskExecutor : ((serviceRequestContext = ServiceRequestContext.currentOrNull()) != null ? serviceRequestContext.blockingTaskExecutor() : CommonPools.blockingTaskExecutor());
        this.inputStreamSubscription = inputStreamSubscription = new InputStreamSubscription(subscriber, executor, blockingTaskExecutor, this.bufferSize, this.offset, this.length, InternalStreamMessageUtil.containsNotifyCancellation(options));
        subscriber.onSubscribe(inputStreamSubscription);
        if (this.completionFuture.isCompletedExceptionally()) {
            this.completionFuture.exceptionally(cause -> {
                inputStreamSubscription.close0(cause);
                return null;
            });
        }
    }

    @Override
    public void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.completionFuture.completeExceptionally(cause);
        InputStreamSubscription inputStreamSubscription = this.inputStreamSubscription;
        if (inputStreamSubscription != null) {
            inputStreamSubscription.close(cause);
        }
    }

    private final class InputStreamSubscription
    implements Subscription {
        private Subscriber<? super HttpData> downstream;
        private final EventExecutor executor;
        private final ExecutorService blockingTaskExecutor;
        private final int bufferSize;
        private final long offset;
        private final long end;
        private long position;
        private volatile boolean written;
        private final boolean notifyCancellation;
        private boolean closed;
        private volatile long requested;
        private boolean reading;

        private InputStreamSubscription(Subscriber<? super HttpData> downstream, EventExecutor executor, ExecutorService blockingTaskExecutor, int bufferSize, long offset, long length, boolean notifyCancellation) {
            Objects.requireNonNull(downstream, "downstream");
            Objects.requireNonNull(executor, "executor");
            Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
            this.downstream = downstream;
            this.executor = executor;
            this.blockingTaskExecutor = blockingTaskExecutor;
            this.bufferSize = bufferSize;
            this.offset = offset;
            this.end = LongMath.saturatedAdd(offset, length);
            this.notifyCancellation = notifyCancellation;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.close(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive subscription requests are forbidden."));
                return;
            }
            if (this.executor.inEventLoop()) {
                this.request0(n);
            } else {
                this.executor.execute(() -> this.request0(n));
            }
        }

        private void request0(long n) {
            if (this.closed) {
                return;
            }
            if (this.offset >= this.end) {
                this.close0(null);
                return;
            }
            long oldRequested = this.requested;
            if (oldRequested == Long.MAX_VALUE) {
                return;
            }
            this.requested = n == Long.MAX_VALUE ? Long.MAX_VALUE : LongMath.saturatedAdd(oldRequested, n);
            if (oldRequested > 0L) {
                return;
            }
            this.readBytes();
        }

        private void readBytes() {
            if (this.reading || this.closed || this.requested <= 0L) {
                return;
            }
            this.reading = true;
            --this.requested;
            this.blockingTaskExecutor.execute(() -> {
                int len;
                if (this.position >= this.end) {
                    this.close(null);
                    return;
                }
                if (this.position < this.offset) {
                    long actualSkipped;
                    long skip = this.offset - this.position;
                    try {
                        actualSkipped = InputStreamStreamMessage.this.inputStream.skip(skip);
                    }
                    catch (Exception e) {
                        this.close(e);
                        return;
                    }
                    if (actualSkipped < skip) {
                        this.close(null);
                        return;
                    }
                    this.position += skip;
                }
                int bufferSize = Math.min(this.bufferSize, Ints.saturatedCast(this.end - this.position));
                byte[] readBytes = new byte[bufferSize];
                try {
                    len = InputStreamStreamMessage.this.inputStream.read(readBytes);
                }
                catch (Exception e) {
                    this.close(e);
                    return;
                }
                if (len == -1) {
                    this.close(null);
                    return;
                }
                HttpData data = HttpData.wrap(readBytes, 0, len);
                this.position += (long)len;
                if (!this.written) {
                    this.written = true;
                }
                this.executor.execute(() -> this.publishDownstream(data));
            });
        }

        private void publishDownstream(HttpData data) {
            if (this.closed) {
                return;
            }
            this.downstream.onNext(data);
            this.reading = false;
            this.readBytes();
        }

        @Override
        public void cancel() {
            if (this.executor.inEventLoop()) {
                this.cancel0();
            } else {
                this.executor.execute(this::cancel0);
            }
        }

        private void cancel0() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            CancelledSubscriptionException cause = CancelledSubscriptionException.get();
            if (this.notifyCancellation) {
                this.downstream.onError(cause);
            }
            this.downstream = NoopSubscriber.get();
            InputStreamStreamMessage.this.completionFuture.completeExceptionally(cause);
            this.closeInputStream();
        }

        private void closeInputStream() {
            try {
                InputStreamStreamMessage.this.inputStream.close();
            }
            catch (IOException e) {
                logger.warn("Unexpected exception while closing input stream {}.", (Object)InputStreamStreamMessage.this.inputStream, (Object)e);
            }
        }

        private void close(@Nullable Throwable cause) {
            if (this.executor.inEventLoop()) {
                this.close0(cause);
            } else {
                this.executor.execute(() -> this.close0(cause));
            }
        }

        private void close0(@Nullable Throwable cause) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (cause == null) {
                this.downstream.onComplete();
                InputStreamStreamMessage.this.completionFuture.complete(null);
            } else {
                this.downstream.onError(cause);
                InputStreamStreamMessage.this.completionFuture.completeExceptionally(cause);
            }
            this.closeInputStream();
        }
    }
}

