/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.client.AggregatedResponseAs;
import com.linecorp.armeria.client.FutureResponseAs;
import com.linecorp.armeria.client.ResponseAs;
import com.linecorp.armeria.client.ResponseAsUtil;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseEntity;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

@UnstableApi
public final class JsonConditionalResponseAs<T> {
    private final List<Map.Entry<Predicate<AggregatedHttpResponse>, ResponseAs<AggregatedHttpResponse, ResponseEntity<T>>>> responseConverters = new ArrayList<Map.Entry<Predicate<AggregatedHttpResponse>, ResponseAs<AggregatedHttpResponse, ResponseEntity<T>>>>();

    JsonConditionalResponseAs(Predicate<AggregatedHttpResponse> predicate, ResponseAs<AggregatedHttpResponse, ResponseEntity<T>> responseAs) {
        this.responseConverters.add(Maps.immutableEntry(Objects.requireNonNull(predicate, "predicate"), Objects.requireNonNull(responseAs, "responseAs")));
    }

    public JsonConditionalResponseAs<T> orElseJson(Class<? extends T> clazz, Predicate<AggregatedHttpResponse> predicate) {
        return this.orElseJson(clazz, ResponseAsUtil.OBJECT_MAPPER, predicate);
    }

    public JsonConditionalResponseAs<T> orElseJson(Class<? extends T> clazz, ObjectMapper objectMapper, Predicate<AggregatedHttpResponse> predicate) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(objectMapper, "objectMapper");
        Objects.requireNonNull(predicate, "predicate");
        this.responseConverters.add(Maps.immutableEntry(predicate, AggregatedResponseAs.json(clazz, objectMapper)));
        return this;
    }

    public JsonConditionalResponseAs<T> orElseJson(TypeReference<? extends T> typeRef, Predicate<AggregatedHttpResponse> predicate) {
        return this.orElseJson(typeRef, ResponseAsUtil.OBJECT_MAPPER, predicate);
    }

    public JsonConditionalResponseAs<T> orElseJson(TypeReference<? extends T> typeRef, ObjectMapper objectMapper, Predicate<AggregatedHttpResponse> predicate) {
        Objects.requireNonNull(typeRef, "typeRef");
        Objects.requireNonNull(objectMapper, "objectMapper");
        Objects.requireNonNull(predicate, "predicate");
        this.responseConverters.add(Maps.immutableEntry(predicate, AggregatedResponseAs.json(typeRef, objectMapper)));
        return this;
    }

    public FutureResponseAs<ResponseEntity<T>> orElseJson(Class<? extends T> clazz) {
        return this.orElseJson(clazz, ResponseAsUtil.OBJECT_MAPPER);
    }

    public FutureResponseAs<ResponseEntity<T>> orElseJson(Class<? extends T> clazz, ObjectMapper objectMapper) {
        return this.orElse(AggregatedResponseAs.json(clazz, objectMapper));
    }

    public FutureResponseAs<ResponseEntity<T>> orElseJson(TypeReference<? extends T> typeRef) {
        return this.orElseJson(typeRef, ResponseAsUtil.OBJECT_MAPPER);
    }

    public FutureResponseAs<ResponseEntity<T>> orElseJson(TypeReference<? extends T> typeRef, ObjectMapper objectMapper) {
        return this.orElse(AggregatedResponseAs.json(typeRef, objectMapper));
    }

    private FutureResponseAs<ResponseEntity<T>> orElse(final ResponseAs<AggregatedHttpResponse, ResponseEntity<T>> lastConverter) {
        final ImmutableList<Map.Entry<Predicate<AggregatedHttpResponse>, ResponseAs<AggregatedHttpResponse, ResponseEntity<T>>>> converters = ImmutableList.copyOf(this.responseConverters);
        return new FutureResponseAs<ResponseEntity<T>>(){

            @Override
            public CompletableFuture<ResponseEntity<T>> as(HttpResponse response) {
                Objects.requireNonNull(response, "response");
                return response.aggregate().thenApply(aggregated -> {
                    for (Map.Entry converter : converters) {
                        if (!((Predicate)converter.getKey()).test(aggregated)) continue;
                        return (ResponseEntity)((ResponseAs)converter.getValue()).as(aggregated);
                    }
                    return (ResponseEntity)lastConverter.as(aggregated);
                });
            }

            @Override
            public boolean requiresAggregation() {
                return true;
            }
        };
    }
}

