/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.config.HierarchyDefinitionService;
import org.apache.skywalking.oap.server.core.hierarchy.instance.InstanceHierarchyRelationTraffic;
import org.apache.skywalking.oap.server.core.hierarchy.service.ServiceHierarchyRelationTraffic;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.HierarchyInstanceRelation;
import org.apache.skywalking.oap.server.core.query.type.HierarchyRelatedInstance;
import org.apache.skywalking.oap.server.core.query.type.HierarchyRelatedService;
import org.apache.skywalking.oap.server.core.query.type.HierarchyServiceRelation;
import org.apache.skywalking.oap.server.core.query.type.InstanceHierarchy;
import org.apache.skywalking.oap.server.core.query.type.LayerLevel;
import org.apache.skywalking.oap.server.core.query.type.ServiceHierarchy;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.query.IHierarchyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HierarchyQueryService.class);
    private final ModuleManager moduleManager;
    private final boolean isEnableHierarchy;
    private IHierarchyQueryDAO hierarchyQueryDAO;
    private IMetadataQueryDAO metadataQueryDAO;
    private Map<String, Map<String, HierarchyDefinitionService.MatchingRule>> hierarchyDefinition;
    private Map<String, Integer> layerLevels;
    private LoadingCache<Boolean, Map<HierarchyRelatedService, ServiceRelations>> serviceHierarchyCache;

    public HierarchyQueryService(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        this.isEnableHierarchy = moduleConfig.isEnableHierarchy();
        if (moduleConfig.isEnableHierarchy()) {
            this.serviceHierarchyCache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite((long)moduleConfig.getServiceCacheRefreshInterval(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Boolean, Map<HierarchyRelatedService, ServiceRelations>>(){

                public Map<HierarchyRelatedService, ServiceRelations> load(Boolean key) throws Exception {
                    return HierarchyQueryService.this.mapServiceHierarchy();
                }
            });
        }
    }

    private IHierarchyQueryDAO getHierarchyQueryDAO() {
        if (this.hierarchyQueryDAO == null) {
            this.hierarchyQueryDAO = (IHierarchyQueryDAO)this.moduleManager.find("storage").provider().getService(IHierarchyQueryDAO.class);
        }
        return this.hierarchyQueryDAO;
    }

    private IMetadataQueryDAO getMetadataQueryDAO() {
        if (this.metadataQueryDAO == null) {
            this.metadataQueryDAO = (IMetadataQueryDAO)this.moduleManager.find("storage").provider().getService(IMetadataQueryDAO.class);
        }
        return this.metadataQueryDAO;
    }

    private Map<String, Map<String, HierarchyDefinitionService.MatchingRule>> getHierarchyDefinition() {
        if (this.hierarchyDefinition == null) {
            this.hierarchyDefinition = ((HierarchyDefinitionService)this.moduleManager.find("core").provider().getService(HierarchyDefinitionService.class)).getHierarchyDefinition();
        }
        return this.hierarchyDefinition;
    }

    private Map<String, Integer> getLayerLevels() {
        if (this.layerLevels == null) {
            this.layerLevels = ((HierarchyDefinitionService)this.moduleManager.find("core").provider().getService(HierarchyDefinitionService.class)).getLayerLevels();
        }
        return this.layerLevels;
    }

    private Map<HierarchyRelatedService, ServiceRelations> mapServiceHierarchy() throws Exception {
        List<ServiceHierarchyRelationTraffic> traffics = this.getHierarchyQueryDAO().readAllServiceHierarchyRelations();
        HashMap<HierarchyRelatedService, ServiceRelations> serviceRelationsMap = new HashMap<HierarchyRelatedService, ServiceRelations>();
        for (ServiceHierarchyRelationTraffic traffic : traffics) {
            HierarchyRelatedService service = new HierarchyRelatedService();
            IDManager.ServiceID.ServiceIDDefinition serviceIdDef = IDManager.ServiceID.analysisId(traffic.getServiceId());
            service.setId(traffic.getServiceId());
            service.setName(serviceIdDef.getName());
            service.setLayer(traffic.getServiceLayer().name());
            service.setNormal(serviceIdDef.isReal());
            HierarchyRelatedService relatedService = new HierarchyRelatedService();
            IDManager.ServiceID.ServiceIDDefinition relatedServiceIdDef = IDManager.ServiceID.analysisId(traffic.getRelatedServiceId());
            relatedService.setId(traffic.getRelatedServiceId());
            relatedService.setName(relatedServiceIdDef.getName());
            relatedService.setLayer(traffic.getRelatedServiceLayer().name());
            relatedService.setNormal(relatedServiceIdDef.isReal());
            ServiceRelations serviceRelations = serviceRelationsMap.computeIfAbsent(service, k -> new ServiceRelations());
            ServiceRelations relationServiceRelations = serviceRelationsMap.computeIfAbsent(relatedService, k -> new ServiceRelations());
            Map lowerLayers = this.getHierarchyDefinition().getOrDefault(traffic.getServiceLayer().name(), new HashMap());
            if (!lowerLayers.containsKey(traffic.getRelatedServiceLayer().name())) continue;
            serviceRelations.getLowerServices().add(relatedService);
            relationServiceRelations.getUpperServices().add(service);
        }
        return serviceRelationsMap;
    }

    private void buildServiceRelation(Map<HierarchyRelatedService, ServiceRelations> serviceRelationsMap, ServiceHierarchy hierarchy, HierarchyRelatedService self, int maxDepth, HierarchyDirection direction) throws ExecutionException {
        HierarchyServiceRelation relation;
        if (maxDepth < 1) {
            return;
        }
        --maxDepth;
        ServiceRelations serviceRelations = serviceRelationsMap.getOrDefault(self, new ServiceRelations());
        if (serviceRelations.getLowerServices().isEmpty() && serviceRelations.getUpperServices().isEmpty()) {
            return;
        }
        if (direction == HierarchyDirection.LOWER || direction == HierarchyDirection.All) {
            for (HierarchyRelatedService lowerService : serviceRelations.getLowerServices()) {
                relation = new HierarchyServiceRelation(self, lowerService);
                if (!hierarchy.getRelations().add(relation)) continue;
                this.buildServiceRelation(serviceRelationsMap, hierarchy, lowerService, maxDepth, direction);
            }
        }
        if (direction == HierarchyDirection.UPPER || direction == HierarchyDirection.All) {
            for (HierarchyRelatedService upperService : serviceRelations.getUpperServices()) {
                relation = new HierarchyServiceRelation(upperService, self);
                if (!hierarchy.getRelations().add(relation)) continue;
                this.buildServiceRelation(serviceRelationsMap, hierarchy, upperService, maxDepth, direction);
            }
        }
    }

    private ServiceHierarchy getServiceHierarchy(String serviceId, String layer, int maxDepth, HierarchyDirection direction) throws Exception {
        ServiceHierarchy hierarchy = new ServiceHierarchy();
        HierarchyRelatedService self = new HierarchyRelatedService();
        self.setId(serviceId);
        self.setName(IDManager.ServiceID.analysisId(serviceId).getName());
        self.setLayer(layer);
        self.setNormal(Layer.nameOf(layer).isNormal());
        this.buildServiceRelation((Map)this.serviceHierarchyCache.get((Object)true), hierarchy, self, maxDepth, direction);
        return hierarchy;
    }

    public ServiceHierarchy getServiceHierarchy(String serviceId, String layer) throws Exception {
        if (!this.isEnableHierarchy) {
            log.warn("CoreModuleConfig config {enableHierarchy} is false, return empty ServiceHierarchy.");
            return new ServiceHierarchy();
        }
        int maxDepth = 10;
        ServiceHierarchy hierarchy = this.getServiceHierarchy(serviceId, layer, maxDepth, HierarchyDirection.All);
        return this.filterConjecturableRelations((Map)this.serviceHierarchyCache.get((Object)true), hierarchy, maxDepth);
    }

    public InstanceHierarchy getInstanceHierarchy(String instanceId, String layer) throws Exception {
        if (!this.isEnableHierarchy) {
            log.warn("CoreModuleConfig config {enableHierarchy} is false, return empty InstanceHierarchy.");
            return new InstanceHierarchy();
        }
        ServiceInstance self = this.getMetadataQueryDAO().getInstance(instanceId);
        if (self == null) {
            return new InstanceHierarchy();
        }
        ArrayList<HierarchyInstanceRelation> relations = new ArrayList<HierarchyInstanceRelation>();
        IDManager.ServiceInstanceID.InstanceIDDefinition idDefinition = IDManager.ServiceInstanceID.analysisId(instanceId);
        IDManager.ServiceID.ServiceIDDefinition serviceIdDefinition = IDManager.ServiceID.analysisId(idDefinition.getServiceId());
        ServiceHierarchy serviceHierarchy = this.getServiceHierarchy(idDefinition.getServiceId(), layer, 1, HierarchyDirection.All);
        Optional<Attribute> host = self.getAttributes().stream().filter(this.hostAttrFilter()).findFirst();
        for (HierarchyServiceRelation hierarchyServiceRelation : serviceHierarchy.getRelations()) {
            HierarchyRelatedInstance relatedInstance;
            List<ServiceInstance> lowerCandidates = this.getMetadataQueryDAO().listInstances(null, hierarchyServiceRelation.getLowerService().getId());
            List<ServiceInstance> upperCandidates = this.getMetadataQueryDAO().listInstances(null, hierarchyServiceRelation.getUpperService().getId());
            Optional<ServiceInstance> lower = lowerCandidates.stream().filter(this.relatedInstanceFilter(self, host)).findFirst();
            Optional<ServiceInstance> upper = upperCandidates.stream().filter(this.relatedInstanceFilter(self, host)).findFirst();
            HierarchyRelatedInstance instance = new HierarchyRelatedInstance();
            instance.setId(self.getId());
            instance.setName(self.getName());
            instance.setServiceId(idDefinition.getServiceId());
            instance.setServiceName(serviceIdDefinition.getName());
            instance.setNormal(serviceIdDefinition.isReal());
            instance.setLayer(layer);
            if (lower.isPresent() && !layer.equals(hierarchyServiceRelation.getLowerService().getLayer())) {
                relatedInstance = new HierarchyRelatedInstance();
                relatedInstance.setId(lower.get().getId());
                relatedInstance.setName(lower.get().getName());
                relatedInstance.setServiceId(hierarchyServiceRelation.getLowerService().getId());
                relatedInstance.setServiceName(hierarchyServiceRelation.getLowerService().getName());
                relatedInstance.setLayer(hierarchyServiceRelation.getLowerService().getLayer());
                relatedInstance.setNormal(hierarchyServiceRelation.getLowerService().isNormal());
                relations.add(new HierarchyInstanceRelation(instance, relatedInstance));
            }
            if (!upper.isPresent() || layer.equals(hierarchyServiceRelation.getUpperService().getLayer())) continue;
            relatedInstance = new HierarchyRelatedInstance();
            relatedInstance.setId(upper.get().getId());
            relatedInstance.setName(upper.get().getName());
            relatedInstance.setServiceId(hierarchyServiceRelation.getUpperService().getId());
            relatedInstance.setServiceName(hierarchyServiceRelation.getUpperService().getName());
            relatedInstance.setLayer(hierarchyServiceRelation.getUpperService().getLayer());
            relatedInstance.setNormal(hierarchyServiceRelation.getUpperService().isNormal());
            relations.add(new HierarchyInstanceRelation(relatedInstance, instance));
        }
        List<InstanceHierarchyRelationTraffic> traffics = this.getHierarchyQueryDAO().readInstanceHierarchyRelations(instanceId, layer);
        for (InstanceHierarchyRelationTraffic traffic : traffics) {
            HierarchyRelatedInstance instance = new HierarchyRelatedInstance();
            IDManager.ServiceInstanceID.InstanceIDDefinition idDef = IDManager.ServiceInstanceID.analysisId(instanceId);
            IDManager.ServiceID.ServiceIDDefinition serviceIdDef = IDManager.ServiceID.analysisId(idDefinition.getServiceId());
            instance.setId(traffic.getInstanceId());
            instance.setName(idDef.getName());
            instance.setServiceId(idDef.getServiceId());
            instance.setServiceName(serviceIdDef.getName());
            instance.setLayer(traffic.getServiceLayer().name());
            instance.setNormal(serviceIdDef.isReal());
            HierarchyRelatedInstance relatedInstance = new HierarchyRelatedInstance();
            IDManager.ServiceInstanceID.InstanceIDDefinition relatedIdDef = IDManager.ServiceInstanceID.analysisId(traffic.getRelatedInstanceId());
            IDManager.ServiceID.ServiceIDDefinition relatedServiceIdDef = IDManager.ServiceID.analysisId(relatedIdDef.getServiceId());
            relatedInstance.setId(traffic.getRelatedInstanceId());
            relatedInstance.setName(relatedIdDef.getName());
            relatedInstance.setServiceId(relatedIdDef.getServiceId());
            relatedInstance.setServiceName(relatedServiceIdDef.getName());
            relatedInstance.setLayer(traffic.getRelatedServiceLayer().name());
            relatedInstance.setNormal(relatedServiceIdDef.isReal());
            Map<String, HierarchyDefinitionService.MatchingRule> lowerLayers = this.getHierarchyDefinition().get(traffic.getServiceLayer().name());
            if (lowerLayers == null || !lowerLayers.containsKey(traffic.getRelatedServiceLayer().name())) continue;
            relations.add(new HierarchyInstanceRelation(instance, relatedInstance));
        }
        InstanceHierarchy instanceHierarchy = new InstanceHierarchy();
        instanceHierarchy.setRelations(relations.stream().distinct().collect(Collectors.toList()));
        return instanceHierarchy;
    }

    public List<LayerLevel> listLayerLevels() {
        return this.getLayerLevels().entrySet().stream().map(entry -> new LayerLevel((String)entry.getKey(), (Integer)entry.getValue())).collect(Collectors.toList());
    }

    private Predicate<Attribute> hostAttrFilter() {
        return attribute -> attribute.getName().equalsIgnoreCase("pod") || attribute.getName().equalsIgnoreCase("hostname");
    }

    private Predicate<ServiceInstance> relatedInstanceFilter(ServiceInstance instance, Optional<Attribute> hostAttr) {
        return candidate -> {
            if (candidate.getName().equals(instance.getName())) {
                return true;
            }
            if (hostAttr.isPresent()) {
                if (candidate.getAttributes().contains(hostAttr.get())) {
                    return true;
                }
                if (candidate.getName().equals(((Attribute)hostAttr.get()).getValue())) {
                    return true;
                }
                return candidate.getAttributes().stream().filter(this.hostAttrFilter()).anyMatch(attr -> attr.getValue().equals(instance.getName()));
            }
            return false;
        };
    }

    private ServiceHierarchy filterConjecturableRelations(Map<HierarchyRelatedService, ServiceRelations> serviceRelationsMap, ServiceHierarchy hierarchy, int maxDepth) {
        Set<HierarchyServiceRelation> relations = hierarchy.getRelations();
        ArrayList<HierarchyServiceRelation> relationList = new ArrayList<HierarchyServiceRelation>(relations);
        for (HierarchyServiceRelation relation : relationList) {
            HierarchyRelatedService upperService = relation.getUpperService();
            HierarchyRelatedService lowerService = relation.getLowerService();
            ServiceRelations serviceRelations = serviceRelationsMap.get(upperService);
            if (serviceRelations.lowerServices.size() <= 1 || !this.checkIfConjecturable(serviceRelationsMap, serviceRelations.lowerServices, lowerService, maxDepth)) continue;
            relations.remove(relation);
        }
        return hierarchy;
    }

    private boolean checkIfConjecturable(Map<HierarchyRelatedService, ServiceRelations> serviceRelationsMap, List<HierarchyRelatedService> services, HierarchyRelatedService conjecturalService, int maxDepth) {
        if (maxDepth < 1) {
            return false;
        }
        --maxDepth;
        for (HierarchyRelatedService service : services) {
            if (service.equals(conjecturalService)) continue;
            List<HierarchyRelatedService> lowerServices = serviceRelationsMap.get((Object)service).lowerServices;
            if (lowerServices.contains(conjecturalService)) {
                return true;
            }
            return this.checkIfConjecturable(serviceRelationsMap, lowerServices, conjecturalService, maxDepth);
        }
        return false;
    }

    public static class ServiceRelations {
        private List<HierarchyRelatedService> upperServices = new ArrayList<HierarchyRelatedService>();
        private List<HierarchyRelatedService> lowerServices = new ArrayList<HierarchyRelatedService>();

        @Generated
        public ServiceRelations() {
        }

        @Generated
        public List<HierarchyRelatedService> getUpperServices() {
            return this.upperServices;
        }

        @Generated
        public List<HierarchyRelatedService> getLowerServices() {
            return this.lowerServices;
        }

        @Generated
        public void setUpperServices(List<HierarchyRelatedService> upperServices) {
            this.upperServices = upperServices;
        }

        @Generated
        public void setLowerServices(List<HierarchyRelatedService> lowerServices) {
            this.lowerServices = lowerServices;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceRelations)) {
                return false;
            }
            ServiceRelations other = (ServiceRelations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<HierarchyRelatedService> this$upperServices = this.getUpperServices();
            List<HierarchyRelatedService> other$upperServices = other.getUpperServices();
            if (this$upperServices == null ? other$upperServices != null : !((Object)this$upperServices).equals(other$upperServices)) {
                return false;
            }
            List<HierarchyRelatedService> this$lowerServices = this.getLowerServices();
            List<HierarchyRelatedService> other$lowerServices = other.getLowerServices();
            return !(this$lowerServices == null ? other$lowerServices != null : !((Object)this$lowerServices).equals(other$lowerServices));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServiceRelations;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<HierarchyRelatedService> $upperServices = this.getUpperServices();
            result = result * 59 + ($upperServices == null ? 43 : ((Object)$upperServices).hashCode());
            List<HierarchyRelatedService> $lowerServices = this.getLowerServices();
            result = result * 59 + ($lowerServices == null ? 43 : ((Object)$lowerServices).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HierarchyQueryService.ServiceRelations(upperServices=" + String.valueOf(this.getUpperServices()) + ", lowerServices=" + String.valueOf(this.getLowerServices()) + ")";
        }
    }

    public static enum HierarchyDirection {
        All,
        UPPER,
        LOWER;

    }
}

