/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.continuous.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.UnexpectedException;

public enum ContinuousProfilingTargetType {
    UNKNOWN(0),
    ON_CPU(1),
    OFF_CPU(2),
    NETWORK(3);

    private final int value;
    private static final Map<Integer, ContinuousProfilingTargetType> DICTIONARY;

    private ContinuousProfilingTargetType(int value) {
        this.value = value;
    }

    public static ContinuousProfilingTargetType valueOf(int value) {
        ContinuousProfilingTargetType type = DICTIONARY.get(value);
        if (type == null) {
            throw new UnexpectedException("Unknown ContinuousProfilingTargetType value");
        }
        return type;
    }

    public int value() {
        return this.value;
    }

    static {
        DICTIONARY = new HashMap<Integer, ContinuousProfilingTargetType>();
        DICTIONARY.putAll(Arrays.stream(ContinuousProfilingTargetType.values()).collect(Collectors.toMap(ContinuousProfilingTargetType::value, type -> type)));
    }
}

