/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.continuous.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.ContinuousProfilingTriggeredMonitorType;
import org.apache.skywalking.oap.server.core.UnexpectedException;

public enum ContinuousProfilingMonitorType {
    UNKNOWN(0, null),
    PROCESS_CPU(1, ContinuousProfilingTriggeredMonitorType.ProcessCPU),
    PROCESS_THREAD_COUNT(2, ContinuousProfilingTriggeredMonitorType.ProcessThreadCount),
    SYSTEM_LOAD(3, ContinuousProfilingTriggeredMonitorType.SystemLoad),
    HTTP_ERROR_RATE(4, ContinuousProfilingTriggeredMonitorType.HTTPErrorRate),
    HTTP_AVG_RESPONSE_TIME(5, ContinuousProfilingTriggeredMonitorType.HTTPAvgResponseTime);

    private final int value;
    private final ContinuousProfilingTriggeredMonitorType causeType;
    private static final Map<Integer, ContinuousProfilingMonitorType> DICTIONARY;
    private static final Map<ContinuousProfilingTriggeredMonitorType, ContinuousProfilingMonitorType> CAUSE_DICTIONARY;

    private ContinuousProfilingMonitorType(int value, ContinuousProfilingTriggeredMonitorType causeType) {
        this.value = value;
        this.causeType = causeType;
    }

    public static ContinuousProfilingMonitorType valueOf(int value) {
        ContinuousProfilingMonitorType type = DICTIONARY.get(value);
        if (type == null) {
            throw new UnexpectedException("Unknown ContinuousProfilingTargetType value");
        }
        return type;
    }

    public static ContinuousProfilingMonitorType valueOf(ContinuousProfilingTriggeredMonitorType causeType) {
        ContinuousProfilingMonitorType type = CAUSE_DICTIONARY.get(causeType);
        if (type == null) {
            throw new UnexpectedException("Unknown ContinuousProfilingTargetType value");
        }
        return type;
    }

    public int value() {
        return this.value;
    }

    static {
        DICTIONARY = new HashMap<Integer, ContinuousProfilingMonitorType>();
        CAUSE_DICTIONARY = new HashMap<ContinuousProfilingTriggeredMonitorType, ContinuousProfilingMonitorType>();
        DICTIONARY.putAll(Arrays.stream(ContinuousProfilingMonitorType.values()).collect(Collectors.toMap(ContinuousProfilingMonitorType::value, Function.identity())));
        CAUSE_DICTIONARY.putAll(Arrays.stream(ContinuousProfilingMonitorType.values()).filter(s -> Objects.nonNull(s.causeType)).collect(Collectors.toMap(s -> s.causeType, Function.identity())));
    }
}

