/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cluster;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.cluster.ClusterHealthStatus;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class OAPNodeChecker {
    private static final Set<String> ILLEGAL_NODE_ADDRESS_IN_CLUSTER_MODE = Sets.newHashSet((Object[])new String[]{"127.0.0.1", "localhost"});
    private static CoreModuleConfig.Role ROLE = CoreModuleConfig.Role.Mixed;

    public static boolean hasIllegalNodeAddress(List<RemoteInstance> remoteInstances) {
        if (CollectionUtils.isEmpty(remoteInstances)) {
            return false;
        }
        Set remoteAddressSet = remoteInstances.stream().map(remoteInstance -> remoteInstance.getAddress().getHost()).collect(Collectors.toSet());
        return !Sets.intersection(ILLEGAL_NODE_ADDRESS_IN_CLUSTER_MODE, remoteAddressSet).isEmpty();
    }

    public static ClusterHealthStatus isHealth(List<RemoteInstance> remoteInstances) {
        List selfInstances;
        if (CollectionUtils.isEmpty(remoteInstances)) {
            return ClusterHealthStatus.unHealth("can't get the instance list");
        }
        if (!CoreModuleConfig.Role.Receiver.equals((Object)ROLE) && CollectionUtils.isEmpty(selfInstances = remoteInstances.stream().filter(remoteInstance -> remoteInstance.getAddress().isSelf()).collect(Collectors.toList()))) {
            return ClusterHealthStatus.unHealth("can't get itself");
        }
        if (remoteInstances.size() > 1 && OAPNodeChecker.hasIllegalNodeAddress(remoteInstances)) {
            return ClusterHealthStatus.unHealth("find illegal node in cluster mode such as 127.0.0.1, localhost");
        }
        return ClusterHealthStatus.HEALTH;
    }

    @Generated
    public static void setROLE(CoreModuleConfig.Role ROLE) {
        OAPNodeChecker.ROLE = ROLE;
    }
}

