/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressAliasCache
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkAddressAliasCache.class);
    private final Cache<String, NetworkAddressAlias> networkAddressAliasCache;

    public NetworkAddressAliasCache(CoreModuleConfig moduleConfig) {
        long initialSize = moduleConfig.getMaxSizeOfNetworkAddressAlias() / 10L;
        int initialCapacitySize = (int)(initialSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : initialSize);
        this.networkAddressAliasCache = CacheBuilder.newBuilder().initialCapacity(initialCapacitySize).maximumSize(moduleConfig.getMaxSizeOfNetworkAddressAlias()).build();
    }

    public NetworkAddressAlias get(String address) {
        return (NetworkAddressAlias)this.networkAddressAliasCache.getIfPresent((Object)address);
    }

    void load(List<NetworkAddressAlias> networkAddressAliasList) {
        networkAddressAliasList.forEach(networkAddressAlias -> this.networkAddressAliasCache.put((Object)networkAddressAlias.getAddress(), networkAddressAlias));
    }

    long currentSize() {
        return this.networkAddressAliasCache.size();
    }
}

