/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpAlarmCallback
implements AlarmCallback {
    protected String post(URI uri, String body, Map<String, String> headers) throws IOException, InterruptedException {
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(uri).POST(HttpRequest.BodyPublishers.ofString(body)).header("Content-Type", "application/json").timeout(Duration.ofSeconds(12L));
        headers.forEach(request::header);
        HttpResponse<String> response = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build().send(request.build(), HttpResponse.BodyHandlers.ofString());
        int status = response.statusCode();
        if (status != 200 && status != 204) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("send to {} failure. Response code: {}, Response content: {}", new Object[]{uri, status, response.body()});
        }
        return response.body();
    }
}

