/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.configuration.discovery;

import com.google.common.hash.Hashing;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.receiver.configuration.discovery.AgentConfigurations;
import org.apache.skywalking.oap.server.receiver.configuration.discovery.AgentConfigurationsTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class AgentConfigurationsReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentConfigurationsReader.class);
    private Map yamlData;

    public AgentConfigurationsReader(InputStream inputStream) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        this.yamlData = (Map)yaml.load(inputStream);
    }

    public AgentConfigurationsReader(Reader io) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        this.yamlData = (Map)yaml.load(io);
    }

    public AgentConfigurationsTable readAgentConfigurationsTable() {
        AgentConfigurationsTable agentConfigurationsTable = new AgentConfigurationsTable();
        try {
            Map configurationsData;
            if (Objects.nonNull(this.yamlData) && (configurationsData = (Map)this.yamlData.get("configurations")) != null) {
                configurationsData.forEach((k, v) -> {
                    Map map = (Map)v;
                    StringBuilder serviceConfigStr = new StringBuilder();
                    HashMap<String, String> config = new HashMap<String, String>(map.size());
                    map.forEach((key, value) -> {
                        config.put(key.toString(), value.toString());
                        serviceConfigStr.append(key).append(":").append(value);
                    });
                    AgentConfigurations agentConfigurations = new AgentConfigurations(k.toString(), config, Hashing.sha512().hashString((CharSequence)serviceConfigStr.toString(), StandardCharsets.UTF_8).toString());
                    agentConfigurationsTable.getAgentConfigurationsCache().put(agentConfigurations.getService(), agentConfigurations);
                });
            }
        }
        catch (Exception e) {
            log.error("Read ConfigurationDiscovery configurations error.", (Throwable)e);
        }
        return agentConfigurationsTable;
    }
}

