/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Internal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class Async {
    public static <T> CombinedBuilder<T> ofExpectedSize(int expectedSize) {
        if (expectedSize == 0) {
            return new Empty();
        }
        if (expectedSize == 1) {
            return new Single();
        }
        return new Many(expectedSize);
    }

    public static <T, U> CompletableFuture<List<U>> each(Collection<T> list, Function<T, CompletableFuture<U>> cfFactory) {
        CombinedBuilder<Object> futures = Async.ofExpectedSize(list.size());
        for (T t : list) {
            CompletableFuture<Object> cf;
            try {
                cf = cfFactory.apply(t);
                Assert.assertNotNull(cf, () -> "cfFactory must return a non null value");
            }
            catch (Exception e) {
                cf = new CompletableFuture();
                cf.completeExceptionally(new CompletionException(e));
            }
            futures.add(cf);
        }
        return futures.await();
    }

    public static <T, U> CompletableFuture<List<U>> eachSequentially(Iterable<T> list, BiFunction<T, List<U>, CompletableFuture<U>> cfFactory) {
        CompletableFuture<List<U>> result = new CompletableFuture<List<U>>();
        Async.eachSequentiallyImpl(list.iterator(), cfFactory, new ArrayList(), result);
        return result;
    }

    private static <T, U> void eachSequentiallyImpl(Iterator<T> iterator, BiFunction<T, List<U>, CompletableFuture<U>> cfFactory, List<U> tmpResult, CompletableFuture<List<U>> overallResult) {
        CompletableFuture<Object> cf;
        if (!iterator.hasNext()) {
            overallResult.complete(tmpResult);
            return;
        }
        try {
            cf = cfFactory.apply(iterator.next(), tmpResult);
            Assert.assertNotNull(cf, () -> "cfFactory must return a non null value");
        }
        catch (Exception e) {
            cf = new CompletableFuture();
            cf.completeExceptionally(new CompletionException(e));
        }
        cf.whenComplete((cfResult, exception) -> {
            if (exception != null) {
                overallResult.completeExceptionally((Throwable)exception);
                return;
            }
            tmpResult.add(cfResult);
            Async.eachSequentiallyImpl(iterator, cfFactory, tmpResult, overallResult);
        });
    }

    public static <T> CompletableFuture<T> toCompletableFuture(T t) {
        if (t instanceof CompletionStage) {
            return ((CompletionStage)t).toCompletableFuture();
        }
        return CompletableFuture.completedFuture(t);
    }

    public static <T> CompletableFuture<T> tryCatch(Supplier<CompletableFuture<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            CompletableFuture result = new CompletableFuture();
            result.completeExceptionally(e);
            return result;
        }
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(Throwable exception) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(exception);
        return result;
    }

    @NotNull
    public static <T> CompletableFuture<T> orNullCompletedFuture(@Nullable CompletableFuture<T> completableFuture) {
        return completableFuture != null ? completableFuture : CompletableFuture.completedFuture(null);
    }

    private static class Many<T>
    implements CombinedBuilder<T> {
        private final CompletableFuture<T>[] array;
        private int ix;

        private Many(int size) {
            this.array = new CompletableFuture[size];
            this.ix = 0;
        }

        @Override
        public void add(CompletableFuture<T> completableFuture) {
            this.array[this.ix++] = completableFuture;
        }

        @Override
        public CompletableFuture<List<T>> await() {
            Assert.assertTrue(this.ix == this.array.length, () -> "expected size was " + this.array.length + " got " + this.ix);
            CompletableFuture<List<T>> overallResult = new CompletableFuture<List<T>>();
            CompletableFuture.allOf(this.array).whenComplete((ignored, exception) -> {
                if (exception != null) {
                    overallResult.completeExceptionally((Throwable)exception);
                    return;
                }
                ArrayList<T> results = new ArrayList<T>(this.array.length);
                for (CompletableFuture<T> future : this.array) {
                    results.add(future.join());
                }
                overallResult.complete(results);
            });
            return overallResult;
        }
    }

    private static class Single<T>
    implements CombinedBuilder<T> {
        private CompletableFuture<T> completableFuture;
        private int ix;

        private Single() {
        }

        @Override
        public void add(CompletableFuture<T> completableFuture) {
            this.completableFuture = completableFuture;
            ++this.ix;
        }

        @Override
        public CompletableFuture<List<T>> await() {
            Assert.assertTrue(this.ix == 1, () -> "expected size was 1 got " + this.ix);
            return this.completableFuture.thenApply(Collections::singletonList);
        }
    }

    private static class Empty<T>
    implements CombinedBuilder<T> {
        private int ix;
        private static final CompletableFuture<List<?>> EMPTY = CompletableFuture.completedFuture(Collections.emptyList());

        private Empty() {
        }

        @Override
        public void add(CompletableFuture<T> completableFuture) {
            ++this.ix;
        }

        @Override
        public CompletableFuture<List<T>> await() {
            Assert.assertTrue(this.ix == 0, () -> "expected size was 0 got " + this.ix);
            return Empty.typedEmpty();
        }

        private static <T> CompletableFuture<T> typedEmpty() {
            return EMPTY;
        }
    }

    public static interface CombinedBuilder<T> {
        public void add(CompletableFuture<T> var1);

        public CompletableFuture<List<T>> await();
    }
}

