/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.PublicApi;
import graphql.language.SourceLocation;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@PublicApi
public class GraphqlErrorException
extends GraphQLException
implements GraphQLError {
    private final List<SourceLocation> locations;
    private final Map<String, Object> extensions;
    private final List<Object> path;
    private final ErrorClassification errorClassification;

    protected GraphqlErrorException(BuilderBase<?, ?> builder) {
        super(builder.message, builder.cause);
        this.locations = builder.sourceLocations;
        this.extensions = builder.extensions;
        this.path = builder.path;
        this.errorClassification = builder.errorClassification;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    @Override
    public ErrorClassification getErrorType() {
        return this.errorClassification;
    }

    @Override
    public List<Object> getPath() {
        return this.path;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public static Builder newErrorException() {
        return new Builder();
    }

    protected static abstract class BuilderBase<T extends BuilderBase<T, B>, B extends GraphqlErrorException> {
        protected String message;
        protected Throwable cause;
        protected ErrorClassification errorClassification = ErrorType.DataFetchingException;
        protected List<SourceLocation> sourceLocations;
        protected Map<String, Object> extensions;
        protected List<Object> path;

        protected BuilderBase() {
        }

        private T asDerivedType() {
            return (T)this;
        }

        public T message(String message) {
            this.message = message;
            return this.asDerivedType();
        }

        public T cause(Throwable cause) {
            this.cause = cause;
            return this.asDerivedType();
        }

        public T sourceLocation(SourceLocation sourceLocation) {
            return this.sourceLocations(sourceLocation == null ? null : Collections.singletonList(sourceLocation));
        }

        public T sourceLocations(List<SourceLocation> sourceLocations) {
            this.sourceLocations = sourceLocations;
            return this.asDerivedType();
        }

        public T errorClassification(ErrorClassification errorClassification) {
            this.errorClassification = errorClassification;
            return this.asDerivedType();
        }

        public T path(List<Object> path) {
            this.path = path;
            return this.asDerivedType();
        }

        public T extensions(Map<String, Object> extensions) {
            this.extensions = extensions;
            return this.asDerivedType();
        }

        public abstract B build();
    }

    public static class Builder
    extends BuilderBase<Builder, GraphqlErrorException> {
        @Override
        public GraphqlErrorException build() {
            return new GraphqlErrorException(this);
        }
    }
}

