/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.telemetry.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.skywalking.oap.server.telemetry.api.MetricFamily;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCollector;

public class PrometheusMetricsCollector
implements MetricsCollector {
    public Iterable<MetricFamily> collect() {
        Enumeration mfs = CollectorRegistry.defaultRegistry.metricFamilySamples();
        ArrayList<MetricFamily> result = new ArrayList<MetricFamily>();
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = (Collector.MetricFamilySamples)mfs.nextElement();
            ArrayList<MetricFamily.Sample> samples = new ArrayList<MetricFamily.Sample>(metricFamilySamples.samples.size());
            MetricFamily m = new MetricFamily(metricFamilySamples.name, MetricFamily.Type.valueOf((String)metricFamilySamples.type.name()), metricFamilySamples.help, samples);
            result.add(m);
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                samples.add(new MetricFamily.Sample(sample.name, sample.labelNames, sample.labelValues, sample.value, sample.timestampMs));
            }
        }
        return result;
    }

    public long heapMemoryUsage() {
        AtomicLong heapMemoryUsed = new AtomicLong();
        this.find("jvm_memory_bytes_used").ifPresent(metricFamily -> metricFamily.samples.forEach(sample -> {
            for (int i = 0; i < sample.labelNames.size(); ++i) {
                if (!((String)sample.labelNames.get(i)).equals("area") || !((String)sample.labelValues.get(i)).equals("heap")) continue;
                heapMemoryUsed.addAndGet((long)sample.value);
            }
        }));
        return heapMemoryUsed.longValue();
    }

    public long heapMemoryMax() {
        AtomicLong heapMemoryMax = new AtomicLong();
        this.find("jvm_memory_bytes_max").ifPresent(metricFamily -> metricFamily.samples.forEach(sample -> {
            for (int i = 0; i < sample.labelNames.size(); ++i) {
                if (!((String)sample.labelNames.get(i)).equals("area") || !((String)sample.labelValues.get(i)).equals("heap")) continue;
                heapMemoryMax.addAndGet((long)sample.value);
            }
        }));
        return heapMemoryMax.longValue();
    }

    public long directMemoryUsage() {
        AtomicLong directMemoryUsed = new AtomicLong();
        this.find("jvm_buffer_pool_used_bytes").ifPresent(metricFamily -> metricFamily.samples.forEach(sample -> {
            for (int i = 0; i < sample.labelNames.size(); ++i) {
                if (!((String)sample.labelNames.get(i)).equals("pool") || !((String)sample.labelValues.get(i)).equals("direct")) continue;
                directMemoryUsed.addAndGet((long)sample.value);
            }
        }));
        return directMemoryUsed.longValue();
    }

    private Optional<MetricFamily> find(String name) {
        for (MetricFamily metricFamily : this.collect()) {
            if (!metricFamily.name.equals(name)) continue;
            return Optional.of(metricFamily);
        }
        return Optional.empty();
    }
}

