/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.AggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.AggregateLabelsFuncFactory;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.AvgAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.MaxAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.MinAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.SumAggregateLabelsFunc;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class AggregateLabelsOp {
    public static ExpressionResult doAggregateLabelsOp(ExpressionResult result, int funcType, List<String> labelNames) throws IllegalExpressionException {
        switch (funcType) {
            case 25: {
                return AggregateLabelsOp.aggregateLabeledValueResult(result, labelNames, AvgAggregateLabelsFunc::new);
            }
            case 30: {
                return AggregateLabelsOp.aggregateLabeledValueResult(result, labelNames, SumAggregateLabelsFunc::new);
            }
            case 28: {
                return AggregateLabelsOp.aggregateLabeledValueResult(result, labelNames, MaxAggregateLabelsFunc::new);
            }
            case 29: {
                return AggregateLabelsOp.aggregateLabeledValueResult(result, labelNames, MinAggregateLabelsFunc::new);
            }
        }
        throw new IllegalExpressionException("Unsupported aggregateLabels function.");
    }

    private static ExpressionResult aggregateLabeledValueResult(ExpressionResult expResult, List<String> labelNames, AggregateLabelsFuncFactory factory) {
        List results = expResult.getResults();
        if (CollectionUtils.isEmpty((List)results)) {
            return expResult;
        }
        LinkedHashMap groupedResult = results.stream().collect(Collectors.groupingBy(mqeValues -> AggregateLabelsOp.getLabels(labelNames, mqeValues), LinkedHashMap::new, Collectors.toList()));
        if (groupedResult.size() == 1 && ((List)groupedResult.keySet().iterator().next()).isEmpty()) {
            expResult.setLabeledResult(false);
        }
        expResult.getResults().clear();
        groupedResult.forEach((labels, mqeValuesList) -> {
            if (mqeValuesList.isEmpty()) {
                return;
            }
            List combineTo = ((MQEValues)mqeValuesList.get(0)).getValues();
            for (int i = 0; i < combineTo.size(); ++i) {
                AggregateLabelsFunc aggregateLabelsFunc = factory.getAggregateLabelsFunc();
                for (MQEValues mqeValues : mqeValuesList) {
                    MQEValue toCombine = (MQEValue)mqeValues.getValues().get(i);
                    if (toCombine.isEmptyValue()) continue;
                    aggregateLabelsFunc.combine(toCombine.getDoubleValue());
                }
                MQEValue mqeValue = (MQEValue)combineTo.get(i);
                mqeValue.setTraceID(null);
                mqeValue.setEmptyValue(true);
                mqeValue.setDoubleValue(0.0);
                Double result = aggregateLabelsFunc.getResult();
                if (result == null) continue;
                mqeValue.setEmptyValue(false);
                mqeValue.setDoubleValue(result.doubleValue());
            }
            MQEValues mqeValues = new MQEValues();
            mqeValues.getMetric().setLabels(labels);
            mqeValues.setValues(combineTo);
            expResult.getResults().add(mqeValues);
        });
        return expResult;
    }

    private static List<KeyValue> getLabels(List<String> labelNames, MQEValues mqeValues) {
        return labelNames.stream().map(labelName -> mqeValues.getMetric().getLabels().stream().filter(label -> labelName.equals(label.getKey())).findAny().orElseGet(() -> new KeyValue(labelName, ""))).collect(Collectors.toList());
    }
}

