/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.response.Mappings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class IndexStructures {
    private final Map<String, Fields> mappingStructures = new HashMap<String, Fields>();
    private final Map<String, UpdatableIndexSettings> indexSettingStructures = new HashMap<String, UpdatableIndexSettings>();

    public Mappings getMapping(String tableName) {
        HashMap properties = this.mappingStructures.containsKey(tableName) ? this.mappingStructures.get((Object)tableName).properties : new HashMap();
        Mappings.Source source = this.mappingStructures.containsKey(tableName) ? this.mappingStructures.get((Object)tableName).source : new Mappings.Source();
        return Mappings.builder().type("type").properties(properties).source(source).build();
    }

    public void putStructure(String tableName, Mappings mapping, Map<String, Object> settings) {
        if (CollectionUtils.isNotEmpty(settings) && Objects.nonNull(settings.get("index"))) {
            this.indexSettingStructures.putIfAbsent(tableName, new UpdatableIndexSettings((Map)settings.get("index")));
        }
        if (Objects.isNull(mapping) || Objects.isNull(mapping.getProperties()) || mapping.getProperties().isEmpty()) {
            return;
        }
        Fields fields = new Fields(mapping);
        if (this.mappingStructures.containsKey(tableName)) {
            this.mappingStructures.get(tableName).appendNewFields(fields);
        } else {
            this.mappingStructures.put(tableName, fields);
        }
    }

    public Mappings diffMappings(String tableName, Mappings mappings) {
        if (!this.mappingStructures.containsKey(tableName)) {
            return new Mappings();
        }
        Map<String, Object> diffProperties = this.mappingStructures.get(tableName).diffFields(new Fields(mappings));
        return Mappings.builder().type("type").properties(diffProperties).build();
    }

    public boolean containsMapping(String tableName, Mappings mappings) {
        if (Objects.isNull(mappings) || CollectionUtils.isEmpty((Map)mappings.getProperties())) {
            return true;
        }
        return this.mappingStructures.containsKey(tableName) && this.mappingStructures.get(tableName).containsAllFields(new Fields(mappings));
    }

    public boolean containsFieldNames(String tableName, Mappings mappings) {
        if (Objects.isNull(mappings) || CollectionUtils.isEmpty((Map)mappings.getProperties())) {
            return true;
        }
        return this.mappingStructures.containsKey(tableName) && this.mappingStructures.get(tableName).containsAllFieldNames(new Fields(mappings));
    }

    public boolean compareIndexSetting(String tableName, Map<String, Object> settings) {
        if ((CollectionUtils.isEmpty(settings) || CollectionUtils.isEmpty((Map)((Map)settings.get("index")))) && Objects.isNull(this.indexSettingStructures.get(tableName))) {
            return true;
        }
        return this.indexSettingStructures.containsKey(tableName) && this.indexSettingStructures.get(tableName).equals(new UpdatableIndexSettings((Map)settings.get("index")));
    }

    public static class Fields {
        private final Map<String, Object> properties;
        private final Mappings.Source source;

        private Fields(Mappings mapping) {
            this.properties = mapping.getProperties();
            this.source = mapping.getSource();
        }

        private boolean containsAllFields(Fields fields) {
            if (this.properties.size() < fields.properties.size()) {
                return false;
            }
            boolean isContains = fields.properties.entrySet().stream().allMatch(item -> Objects.equals(this.properties.get(item.getKey()), item.getValue()));
            if (!isContains) {
                return false;
            }
            Set inputExcludes = fields.source.getExcludes();
            Set excludes = this.source.getExcludes();
            if (!excludes.containsAll(inputExcludes)) {
                return false;
            }
            for (String p : fields.properties.keySet()) {
                if (inputExcludes.contains(p) || !excludes.contains(p)) continue;
                return false;
            }
            return true;
        }

        private boolean containsAllFieldNames(Fields fields) {
            if (this.properties.size() < fields.properties.size()) {
                return false;
            }
            return this.properties.keySet().containsAll(fields.properties.keySet());
        }

        private void appendNewFields(Fields fields) {
            this.properties.putAll(fields.properties);
            Set inputExcludes = fields.source.getExcludes();
            Set excludes = this.source.getExcludes();
            excludes.addAll(inputExcludes);
            fields.properties.keySet().forEach(p -> {
                if (!inputExcludes.contains(p) && excludes.contains(p)) {
                    excludes.remove(p);
                }
            });
        }

        private Map<String, Object> diffFields(Fields fields) {
            return this.properties.entrySet().stream().filter(e -> !fields.properties.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static class UpdatableIndexSettings {
        private final String replicas;
        private final String shards;

        public UpdatableIndexSettings(Map<String, Object> indexSettings) {
            this.replicas = String.valueOf(indexSettings.getOrDefault("number_of_replicas", ""));
            this.shards = String.valueOf(indexSettings.getOrDefault("number_of_shards", ""));
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdatableIndexSettings)) {
                return false;
            }
            UpdatableIndexSettings other = (UpdatableIndexSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$replicas = this.replicas;
            String other$replicas = other.replicas;
            if (this$replicas == null ? other$replicas != null : !this$replicas.equals(other$replicas)) {
                return false;
            }
            String this$shards = this.shards;
            String other$shards = other.shards;
            return !(this$shards == null ? other$shards != null : !this$shards.equals(other$shards));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpdatableIndexSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $replicas = this.replicas;
            result = result * 59 + ($replicas == null ? 43 : $replicas.hashCode());
            String $shards = this.shards;
            result = result * 59 + ($shards == null ? 43 : $shards.hashCode());
            return result;
        }
    }
}

