/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.pprof.type;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.pprof.type.Frame;

public class FrameTree {
    private String signature;
    private long total;
    private long self;
    private List<FrameTree> children;

    public FrameTree(Frame frame) {
        this.signature = frame.getSignature();
        this.total = frame.getTotal();
        this.self = frame.getSelf();
        this.children = new ArrayList<FrameTree>(frame.size());
    }

    public FrameTree(String signature, long total, long self) {
        this.signature = signature;
        this.total = total;
        this.self = self;
        this.children = new ArrayList<FrameTree>();
    }

    public static FrameTree buildTree(Frame frame) {
        if (frame == null) {
            return null;
        }
        FrameTree frameTree = new FrameTree(frame);
        if (!frame.isEmpty()) {
            frameTree.children = new ArrayList<FrameTree>(frame.size());
            for (Frame childFrame : frame.values()) {
                FrameTree childFrameTree = FrameTree.buildTree(childFrame);
                frameTree.children.add(childFrameTree);
            }
        }
        return frameTree;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public long getSelf() {
        return this.self;
    }

    @Generated
    public List<FrameTree> getChildren() {
        return this.children;
    }
}

