/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.ServiceOptions;

@UnstableApi
public final class ServiceOptionsBuilder {
    private long requestTimeoutMillis = -1L;
    private long maxRequestLength = -1L;
    private long requestAutoAbortDelayMillis = -1L;

    ServiceOptionsBuilder() {
    }

    public ServiceOptionsBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        Preconditions.checkArgument(requestTimeoutMillis >= 0L, "requestTimeoutMillis: %s (expected: >= 0)", requestTimeoutMillis);
        this.requestTimeoutMillis = requestTimeoutMillis;
        return this;
    }

    public ServiceOptionsBuilder maxRequestLength(long maxRequestLength) {
        Preconditions.checkArgument(maxRequestLength >= 0L, "maxRequestLength: %s (expected: >= 0)", maxRequestLength);
        this.maxRequestLength = maxRequestLength;
        return this;
    }

    public ServiceOptionsBuilder requestAutoAbortDelayMillis(long requestAutoAbortDelayMillis) {
        Preconditions.checkArgument(requestAutoAbortDelayMillis >= 0L, "requestAutoAbortDelayMillis: %s (expected: >= 0)", requestAutoAbortDelayMillis);
        this.requestAutoAbortDelayMillis = requestAutoAbortDelayMillis;
        return this;
    }

    public ServiceOptions build() {
        return new ServiceOptions(this.requestTimeoutMillis, this.maxRequestLength, this.requestAutoAbortDelayMillis);
    }
}

