/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.util;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.util.MinifiedBouncyCastleProvider;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.X500Name;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.Extension;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.GeneralName;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.GeneralNames;
import com.linecorp.armeria.internal.shaded.bouncycastle.cert.X509CertificateHolder;
import com.linecorp.armeria.internal.shaded.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.linecorp.armeria.internal.shaded.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import com.linecorp.armeria.internal.shaded.bouncycastle.operator.ContentSigner;
import com.linecorp.armeria.internal.shaded.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelfSignedCertificate {
    private static final Logger logger = LoggerFactory.getLogger(SelfSignedCertificate.class);
    private static final Provider bouncyCastleProvider = new MinifiedBouncyCastleProvider();
    private static final Date DEFAULT_NOT_BEFORE = new Date(SystemPropertyUtil.getLong((String)"io.netty.selfSignedCertificate.defaultNotBefore", (long)(System.currentTimeMillis() - 31536000000L)));
    private static final Date DEFAULT_NOT_AFTER = new Date(SystemPropertyUtil.getLong((String)"io.netty.selfSignedCertificate.defaultNotAfter", (long)253402300799000L));
    private static final int DEFAULT_KEY_LENGTH_BITS = SystemPropertyUtil.getInt((String)"io.netty.handler.ssl.util.selfSignedKeyStrength", (int)2048);
    private final File certificate;
    private final File privateKey;
    private final X509Certificate cert;
    private final PrivateKey key;

    public SelfSignedCertificate() throws CertificateException {
        this(DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, "RSA", DEFAULT_KEY_LENGTH_BITS);
    }

    public SelfSignedCertificate(Date notBefore, Date notAfter) throws CertificateException {
        this("localhost", notBefore, notAfter, "RSA", DEFAULT_KEY_LENGTH_BITS);
    }

    public SelfSignedCertificate(Date notBefore, Date notAfter, String algorithm, int bits) throws CertificateException {
        this("localhost", notBefore, notAfter, algorithm, bits);
    }

    public SelfSignedCertificate(String fqdn) throws CertificateException {
        this(fqdn, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, "RSA", DEFAULT_KEY_LENGTH_BITS);
    }

    public SelfSignedCertificate(String fqdn, String algorithm, int bits) throws CertificateException {
        this(fqdn, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, algorithm, bits);
    }

    public SelfSignedCertificate(String fqdn, Date notBefore, Date notAfter) throws CertificateException {
        this(fqdn, ThreadLocalRandom.current(), DEFAULT_KEY_LENGTH_BITS, notBefore, notAfter, "RSA");
    }

    public SelfSignedCertificate(String fqdn, Date notBefore, Date notAfter, String algorithm, int bits) throws CertificateException {
        this(fqdn, ThreadLocalRandom.current(), bits, notBefore, notAfter, algorithm);
    }

    public SelfSignedCertificate(String fqdn, Random random, int bits) throws CertificateException {
        this(fqdn, random, bits, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, "RSA");
    }

    public SelfSignedCertificate(String fqdn, Random random, String algorithm, int bits) throws CertificateException {
        this(fqdn, random, bits, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, algorithm);
    }

    public SelfSignedCertificate(String fqdn, Random random, int bits, Date notBefore, Date notAfter) throws CertificateException {
        this(fqdn, random, bits, notBefore, notAfter, "RSA");
    }

    public SelfSignedCertificate(String fqdn, Random random, int bits, Date notBefore, Date notAfter, String algorithm) throws CertificateException {
        KeyPair keypair;
        if (!"EC".equalsIgnoreCase(algorithm) && !"RSA".equalsIgnoreCase(algorithm)) {
            throw new IllegalArgumentException("Algorithm not valid: " + algorithm);
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
            keyGen.initialize(bits, SelfSignedCertificate.toSecureRandom(random));
            keypair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        String[] paths = MinifiedBouncyCastleProvider.call(() -> {
            try {
                return SelfSignedCertificate.generate(fqdn, keypair, random, notBefore, notAfter, algorithm);
            }
            catch (Throwable cause) {
                return (String[])Exceptions.throwUnsafely(new CertificateException("Failed to generate a self-signed X.509 certificate: " + cause, cause));
            }
        });
        this.certificate = new File(paths[0]);
        this.privateKey = new File(paths[1]);
        this.key = keypair.getPrivate();
        FileInputStream certificateInput = null;
        try {
            certificateInput = new FileInputStream(this.certificate);
            this.cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(certificateInput);
        }
        catch (Exception e) {
            throw new CertificateEncodingException(e);
        }
        finally {
            block14: {
                if (certificateInput != null) {
                    try {
                        certificateInput.close();
                    }
                    catch (IOException e) {
                        if (!logger.isWarnEnabled()) break block14;
                        logger.warn("Failed to close a file: {}", (Object)this.certificate, (Object)e);
                    }
                }
            }
        }
    }

    public File certificate() {
        return this.certificate;
    }

    public File privateKey() {
        return this.privateKey;
    }

    public X509Certificate cert() {
        return this.cert;
    }

    public PrivateKey key() {
        return this.key;
    }

    public void delete() {
        SelfSignedCertificate.safeDelete(this.certificate);
        SelfSignedCertificate.safeDelete(this.privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] generate(String fqdn, KeyPair keypair, Random random, Date notBefore, Date notAfter, String algorithm) throws Exception {
        String certText;
        String keyText;
        ByteBuf encodedBuf;
        PrivateKey key = keypair.getPrivate();
        X500Name owner = new X500Name("CN=" + fqdn);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, random), notBefore, notAfter, owner, keypair.getPublic());
        ArrayList<GeneralName> names = new ArrayList<GeneralName>();
        if (NetUtil.isValidIpV4Address((String)fqdn) || NetUtil.isValidIpV6Address((String)fqdn)) {
            names.add(new GeneralName(7, fqdn));
        } else {
            names.add(new GeneralName(2, fqdn));
        }
        if ("localhost".equals(fqdn)) {
            names.add(new GeneralName(7, "127.0.0.1"));
            names.add(new GeneralName(7, "::1"));
        } else if ("127.0.0.1".equals(fqdn)) {
            names.add(new GeneralName(2, "localhost"));
            names.add(new GeneralName(7, "::1"));
        }
        builder.addExtension(Extension.subjectAlternativeName, false, new GeneralNames(names.toArray(new GeneralName[0])));
        ContentSigner signer = new JcaContentSignerBuilder("EC".equalsIgnoreCase(algorithm) ? "SHA256withECDSA" : "SHA256WithRSAEncryption").build(key);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(bouncyCastleProvider).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        ByteBuf wrappedBuf = Unpooled.wrappedBuffer((byte[])key.getEncoded());
        try {
            encodedBuf = Base64.encode((ByteBuf)wrappedBuf, (boolean)true);
            try {
                keyText = "-----BEGIN PRIVATE KEY-----\n" + encodedBuf.toString(CharsetUtil.US_ASCII) + "\n-----END PRIVATE KEY-----\n";
            }
            finally {
                encodedBuf.release();
            }
        }
        finally {
            wrappedBuf.release();
        }
        fqdn = fqdn.replaceAll("[^\\w.-]", "x");
        File keyFile = PlatformDependent.createTempFile((String)("keyutil_" + fqdn + '_'), (String)".key", null);
        keyFile.deleteOnExit();
        FileOutputStream keyOut = new FileOutputStream(keyFile);
        try {
            ((OutputStream)keyOut).write(keyText.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)keyOut).close();
            keyOut = null;
        }
        finally {
            if (keyOut != null) {
                SelfSignedCertificate.safeClose(keyFile, keyOut);
                SelfSignedCertificate.safeDelete(keyFile);
            }
        }
        wrappedBuf = Unpooled.wrappedBuffer((byte[])cert.getEncoded());
        try {
            encodedBuf = Base64.encode((ByteBuf)wrappedBuf, (boolean)true);
            try {
                certText = "-----BEGIN CERTIFICATE-----\n" + encodedBuf.toString(CharsetUtil.US_ASCII) + "\n-----END CERTIFICATE-----\n";
            }
            finally {
                encodedBuf.release();
            }
        }
        finally {
            wrappedBuf.release();
        }
        File certFile = PlatformDependent.createTempFile((String)("keyutil_" + fqdn + '_'), (String)".crt", null);
        certFile.deleteOnExit();
        FileOutputStream certOut = new FileOutputStream(certFile);
        try {
            ((OutputStream)certOut).write(certText.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)certOut).close();
            certOut = null;
        }
        finally {
            if (certOut != null) {
                SelfSignedCertificate.safeClose(certFile, certOut);
                SelfSignedCertificate.safeDelete(certFile);
                SelfSignedCertificate.safeDelete(keyFile);
            }
        }
        return new String[]{certFile.getPath(), keyFile.getPath()};
    }

    private static void safeDelete(File certFile) {
        if (!certFile.delete() && logger.isWarnEnabled()) {
            logger.warn("Failed to delete a file: " + certFile);
        }
    }

    private static void safeClose(File keyFile, OutputStream keyOut) {
        block2: {
            try {
                keyOut.close();
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to close a file: " + keyFile, (Throwable)e);
            }
        }
    }

    private static SecureRandom toSecureRandom(final Random random) {
        if (random instanceof SecureRandom) {
            return (SecureRandom)random;
        }
        return new SecureRandom(){
            private static final long serialVersionUID = -4101939112170161136L;

            @Override
            public String getAlgorithm() {
                return "unknown";
            }

            @Override
            public void setSeed(byte[] seed) {
            }

            @Override
            public void setSeed(long seed) {
            }

            @Override
            public void nextBytes(byte[] bytes) {
                random.nextBytes(bytes);
            }

            @Override
            public byte[] generateSeed(int numBytes) {
                byte[] seed = new byte[numBytes];
                random.nextBytes(seed);
                return seed;
            }

            @Override
            public int nextInt() {
                return random.nextInt();
            }

            @Override
            public int nextInt(int n) {
                return random.nextInt(n);
            }

            @Override
            public boolean nextBoolean() {
                return random.nextBoolean();
            }

            @Override
            public long nextLong() {
                return random.nextLong();
            }

            @Override
            public float nextFloat() {
                return random.nextFloat();
            }

            @Override
            public double nextDouble() {
                return random.nextDouble();
            }

            @Override
            public double nextGaussian() {
                return random.nextGaussian();
            }
        };
    }
}

