/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.retry.RetryConfigBuilder;
import com.linecorp.armeria.client.retry.RetryRule;
import com.linecorp.armeria.client.retry.RetryRuleUtil;
import com.linecorp.armeria.client.retry.RetryRuleWithContent;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryConfig<T extends Response> {
    private static final Logger logger = LoggerFactory.getLogger(RetryConfig.class);
    private final int maxTotalAttempts;
    private final long responseTimeoutMillisForEachAttempt;
    private final int maxContentLength;
    @Nullable
    private final RetryRule retryRule;
    @Nullable
    private final RetryRuleWithContent<T> retryRuleWithContent;
    @Nullable
    private final RetryRule fromRetryRuleWithContent;
    @Nullable
    private RetryRuleWithContent<T> fromRetryRule;

    public static RetryConfigBuilder<HttpResponse> builder(RetryRule retryRule) {
        return RetryConfig.builder0(retryRule);
    }

    public static RetryConfigBuilder<HttpResponse> builder(RetryRuleWithContent<HttpResponse> retryRuleWithContent) {
        return RetryConfig.builder0(retryRuleWithContent);
    }

    public static RetryConfigBuilder<RpcResponse> builderForRpc(RetryRule retryRule) {
        return RetryConfig.builder0(retryRule);
    }

    public static RetryConfigBuilder<RpcResponse> builderForRpc(RetryRuleWithContent<RpcResponse> retryRuleWithContent) {
        return RetryConfig.builder0(retryRuleWithContent);
    }

    static <T extends Response> RetryConfigBuilder<T> builder0(RetryRule retryRule) {
        return new RetryConfigBuilder(retryRule);
    }

    static <T extends Response> RetryConfigBuilder<T> builder0(RetryRuleWithContent<T> retryRuleWithContent) {
        return new RetryConfigBuilder<T>(retryRuleWithContent);
    }

    RetryConfig(RetryRule retryRule, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        this(Objects.requireNonNull(retryRule, "retryRule"), null, maxTotalAttempts, responseTimeoutMillisForEachAttempt, 0);
        RetryConfig.checkArguments(maxTotalAttempts, responseTimeoutMillisForEachAttempt);
    }

    RetryConfig(RetryRuleWithContent<T> retryRuleWithContent, int maxContentLength, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        this(null, Objects.requireNonNull(retryRuleWithContent, "retryRuleWithContent"), maxTotalAttempts, responseTimeoutMillisForEachAttempt, maxContentLength);
    }

    private RetryConfig(@Nullable RetryRule retryRule, @Nullable RetryRuleWithContent<T> retryRuleWithContent, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt, int maxContentLength) {
        RetryConfig.checkArguments(maxTotalAttempts, responseTimeoutMillisForEachAttempt);
        this.retryRule = retryRule;
        this.retryRuleWithContent = retryRuleWithContent;
        this.maxTotalAttempts = maxTotalAttempts;
        this.responseTimeoutMillisForEachAttempt = responseTimeoutMillisForEachAttempt;
        this.maxContentLength = maxContentLength;
        this.fromRetryRuleWithContent = retryRuleWithContent == null ? null : RetryRuleUtil.fromRetryRuleWithContent(retryRuleWithContent);
    }

    private static void checkArguments(int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        Preconditions.checkArgument(maxTotalAttempts > 0, "maxTotalAttempts: %s (expected: > 0)", maxTotalAttempts);
        Preconditions.checkArgument(responseTimeoutMillisForEachAttempt >= 0L, "responseTimeoutMillisForEachAttempt: %s (expected: >= 0)", responseTimeoutMillisForEachAttempt);
    }

    public RetryConfigBuilder<T> toBuilder() {
        RetryConfigBuilder<T> builder;
        if (this.retryRuleWithContent != null) {
            builder = RetryConfig.builder0(this.retryRuleWithContent).maxContentLength(this.maxContentLength);
        } else {
            assert (this.retryRule != null);
            builder = RetryConfig.builder0(this.retryRule);
        }
        return builder.maxTotalAttempts(this.maxTotalAttempts).responseTimeoutMillisForEachAttempt(this.responseTimeoutMillisForEachAttempt);
    }

    public int maxTotalAttempts() {
        return this.maxTotalAttempts;
    }

    public long responseTimeoutMillisForEachAttempt() {
        return this.responseTimeoutMillisForEachAttempt;
    }

    @Nullable
    public RetryRule retryRule() {
        return this.retryRule;
    }

    @Nullable
    public RetryRuleWithContent<T> retryRuleWithContent() {
        return this.retryRuleWithContent;
    }

    public int maxContentLength() {
        return this.maxContentLength;
    }

    public boolean needsContentInRule() {
        return this.retryRuleWithContent != null;
    }

    public boolean requiresResponseTrailers() {
        if (this.needsContentInRule()) {
            RetryRuleWithContent<T> rule = this.retryRuleWithContent();
            assert (rule != null);
            return rule.requiresResponseTrailers();
        }
        RetryRule rule = this.retryRule();
        assert (rule != null);
        return rule.requiresResponseTrailers();
    }

    RetryRule fromRetryRuleWithContent() {
        Objects.requireNonNull(this.retryRuleWithContent, "retryRuleWithContent");
        Objects.requireNonNull(this.fromRetryRuleWithContent, "fromRetryRuleWithContent");
        return this.fromRetryRuleWithContent;
    }

    RetryRuleWithContent<T> fromRetryRule() {
        Objects.requireNonNull(this.retryRule, "retryRule");
        if (this.fromRetryRule == null) {
            logger.warn("A RetryRuleWithContent is being generated from a RetryRule. You are probably using a RetryRule with a RetryingRpcClient. Please ensure that this is intentional.");
            this.fromRetryRule = RetryRuleUtil.fromRetryRule(this.retryRule);
        }
        return this.fromRetryRule;
    }
}

