/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractEventLoopEntry;
import com.linecorp.armeria.client.ArrayBasedEventLoopState;
import com.linecorp.armeria.client.DefaultEventLoopScheduler;
import com.linecorp.armeria.client.HeapBasedEventLoopState;
import com.linecorp.armeria.client.OneEventLoopState;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import io.netty.channel.EventLoop;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractEventLoopState {
    private final ReentrantLock lock = new ReentrantShortLock();
    private final List<EventLoop> eventLoops;
    private final DefaultEventLoopScheduler scheduler;
    private long lastActivityTimeNanos = System.nanoTime();

    static AbstractEventLoopState of(List<EventLoop> eventLoops, int maxNumEventLoops, DefaultEventLoopScheduler scheduler) {
        if (maxNumEventLoops == 1) {
            return new OneEventLoopState(eventLoops, scheduler);
        }
        if (maxNumEventLoops <= 128) {
            return new ArrayBasedEventLoopState(eventLoops, maxNumEventLoops, scheduler);
        }
        return new HeapBasedEventLoopState(eventLoops, maxNumEventLoops, scheduler);
    }

    AbstractEventLoopState(List<EventLoop> eventLoops, DefaultEventLoopScheduler scheduler) {
        this.eventLoops = eventLoops;
        this.scheduler = scheduler;
    }

    final List<EventLoop> eventLoops() {
        return this.eventLoops;
    }

    final DefaultEventLoopScheduler scheduler() {
        return this.scheduler;
    }

    final long lastActivityTimeNanos() {
        return this.lastActivityTimeNanos;
    }

    final void setLastActivityTimeNanos() {
        this.lastActivityTimeNanos = System.nanoTime();
    }

    protected final void lock() {
        this.lock.lock();
    }

    protected final void unlock() {
        this.lock.unlock();
    }

    abstract AbstractEventLoopEntry acquire();

    abstract void release(AbstractEventLoopEntry var1);

    abstract AbstractEventLoopEntry[] entries();

    abstract int allActiveRequests();
}

