/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.protobuf;

import com.google.protobuf.Message;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunctionProvider;
import com.linecorp.armeria.server.protobuf.ProtobufRequestConverterFunction;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

@UnstableApi
public final class ProtobufRequestConverterFunctionProvider
implements RequestConverterFunctionProvider {
    @Nullable
    public RequestConverterFunction createRequestConverterFunction(Type requestType, RequestConverterFunction requestConverter) {
        ProtobufRequestConverterFunction.ResultType resultType = ProtobufRequestConverterFunctionProvider.toResultType(requestType);
        if (resultType != ProtobufRequestConverterFunction.ResultType.UNKNOWN) {
            return new ProtobufRequestConverterFunction(resultType);
        }
        return null;
    }

    static ProtobufRequestConverterFunction.ResultType toResultType(Type type) {
        if (type instanceof Class && ProtobufRequestConverterFunctionProvider.isProtobufMessage((Class)type)) {
            return ProtobufRequestConverterFunction.ResultType.PROTOBUF;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            if (List.class.isAssignableFrom(rawType)) {
                Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
                if (!(actualTypeArgument instanceof Class)) {
                    return ProtobufRequestConverterFunction.ResultType.UNKNOWN;
                }
                if (ProtobufRequestConverterFunctionProvider.isProtobufMessage((Class)actualTypeArgument)) {
                    return ProtobufRequestConverterFunction.ResultType.LIST_PROTOBUF;
                }
            } else if (Set.class.isAssignableFrom(rawType)) {
                Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
                if (!(actualTypeArgument instanceof Class)) {
                    return ProtobufRequestConverterFunction.ResultType.UNKNOWN;
                }
                if (ProtobufRequestConverterFunctionProvider.isProtobufMessage((Class)actualTypeArgument)) {
                    return ProtobufRequestConverterFunction.ResultType.SET_PROTOBUF;
                }
            } else if (Map.class.isAssignableFrom(rawType)) {
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                if (!(typeArguments[0] instanceof Class)) {
                    return ProtobufRequestConverterFunction.ResultType.UNKNOWN;
                }
                Class keyType = (Class)typeArguments[0];
                if (!String.class.isAssignableFrom(keyType)) {
                    return ProtobufRequestConverterFunction.ResultType.UNKNOWN;
                }
                if (!(typeArguments[1] instanceof Class)) {
                    return ProtobufRequestConverterFunction.ResultType.UNKNOWN;
                }
                if (ProtobufRequestConverterFunctionProvider.isProtobufMessage((Class)typeArguments[1])) {
                    return ProtobufRequestConverterFunction.ResultType.MAP_PROTOBUF;
                }
            }
        }
        return ProtobufRequestConverterFunction.ResultType.UNKNOWN;
    }

    static boolean isProtobufMessage(Class<?> clazz) {
        return Message.class.isAssignableFrom(clazz);
    }
}

