/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;

@JsonSerialize(using=BoolQuerySerializer.class)
public final class BoolQuery
extends Query {
    private final ImmutableList<Query> must;
    private final ImmutableList<Query> mustNot;
    private final ImmutableList<Query> should;
    private final ImmutableList<Query> shouldNot;

    @Generated
    public ImmutableList<Query> getMust() {
        return this.must;
    }

    @Generated
    public ImmutableList<Query> getMustNot() {
        return this.mustNot;
    }

    @Generated
    public ImmutableList<Query> getShould() {
        return this.should;
    }

    @Generated
    public ImmutableList<Query> getShouldNot() {
        return this.shouldNot;
    }

    @Generated
    BoolQuery(ImmutableList<Query> must, ImmutableList<Query> mustNot, ImmutableList<Query> should, ImmutableList<Query> shouldNot) {
        this.must = must;
        this.mustNot = mustNot;
        this.should = should;
        this.shouldNot = shouldNot;
    }

    static final class BoolQuerySerializer
    extends JsonSerializer<BoolQuery> {
        static final String NAME = "bool";
        static final String MUST = "must";
        static final String MUST_NOT = "must_not";
        static final String SHOULD = "should";
        static final String SHOULD_NOT = "should_not";

        BoolQuerySerializer() {
        }

        public void serialize(BoolQuery value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName(NAME);
            gen.writeStartObject();
            this.writeArray(gen, MUST, (List<Query>)value.getMust());
            this.writeArray(gen, MUST_NOT, (List<Query>)value.getMustNot());
            this.writeArray(gen, SHOULD, (List<Query>)value.getShould());
            this.writeArray(gen, SHOULD_NOT, (List<Query>)value.getShouldNot());
            gen.writeEndObject();
            gen.writeEndObject();
        }

        private void writeArray(JsonGenerator gen, String name, List<Query> array) throws IOException {
            if (array == null || array.isEmpty()) {
                return;
            }
            gen.writeFieldName(name);
            gen.writeStartArray();
            for (Query query : array) {
                gen.writeObject((Object)query);
            }
            gen.writeEndArray();
        }
    }
}

