/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.streaming;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.server.ResponseConversionUtil;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonTextSequences {
    private static final Logger logger = LoggerFactory.getLogger(JsonTextSequences.class);
    private static boolean warnedStatusCode;
    private static boolean warnedContentType;
    private static final byte RECORD_SEPARATOR = 30;
    private static final byte LINE_FEED = 10;
    private static final ObjectMapper defaultMapper;
    private static final ResponseHeaders defaultHttpHeaders;

    public static HttpResponse fromPublisher(Publisher<?> contentPublisher) {
        return JsonTextSequences.fromPublisher(defaultHttpHeaders, contentPublisher, HttpHeaders.of(), defaultMapper);
    }

    public static HttpResponse fromPublisher(Publisher<?> contentPublisher, ObjectMapper mapper) {
        return JsonTextSequences.fromPublisher(defaultHttpHeaders, contentPublisher, HttpHeaders.of(), mapper);
    }

    public static HttpResponse fromPublisher(ResponseHeaders headers, Publisher<?> contentPublisher) {
        return JsonTextSequences.fromPublisher(headers, contentPublisher, HttpHeaders.of(), defaultMapper);
    }

    public static HttpResponse fromPublisher(ResponseHeaders headers, Publisher<?> contentPublisher, ObjectMapper mapper) {
        return JsonTextSequences.fromPublisher(headers, contentPublisher, HttpHeaders.of(), mapper);
    }

    public static HttpResponse fromPublisher(ResponseHeaders headers, Publisher<?> contentPublisher, HttpHeaders trailers, ObjectMapper mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return ResponseConversionUtil.streamingFrom(contentPublisher, JsonTextSequences.sanitizeHeaders(headers), trailers, o -> JsonTextSequences.toHttpData(mapper, o));
    }

    static <T> HttpResponse fromPublisher(ResponseHeaders headers, Publisher<T> contentPublisher, HttpHeaders trailers, Function<? super T, String> contentConverter) {
        Objects.requireNonNull(contentConverter, "contentConverter");
        return ResponseConversionUtil.streamingFrom(contentPublisher, JsonTextSequences.sanitizeHeaders(headers), trailers, o -> JsonTextSequences.toHttpData(contentConverter, o));
    }

    public static HttpResponse fromStream(Stream<?> contentStream, Executor executor) {
        return JsonTextSequences.fromStream(defaultHttpHeaders, contentStream, HttpHeaders.of(), executor, defaultMapper);
    }

    public static HttpResponse fromStream(Stream<?> contentStream, Executor executor, ObjectMapper mapper) {
        return JsonTextSequences.fromStream(defaultHttpHeaders, contentStream, HttpHeaders.of(), executor, mapper);
    }

    public static HttpResponse fromStream(ResponseHeaders headers, Stream<?> contentStream, Executor executor) {
        return JsonTextSequences.fromStream(headers, contentStream, HttpHeaders.of(), executor, defaultMapper);
    }

    public static HttpResponse fromStream(ResponseHeaders headers, Stream<?> contentStream, Executor executor, ObjectMapper mapper) {
        return JsonTextSequences.fromStream(headers, contentStream, HttpHeaders.of(), executor, mapper);
    }

    public static HttpResponse fromStream(ResponseHeaders headers, Stream<?> contentStream, HttpHeaders trailers, Executor executor, ObjectMapper mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return ResponseConversionUtil.streamingFrom(contentStream, JsonTextSequences.sanitizeHeaders(headers), trailers, o -> JsonTextSequences.toHttpData(mapper, o), executor);
    }

    static <T> HttpResponse fromStream(ResponseHeaders headers, Stream<T> contentStream, HttpHeaders trailers, Executor executor, Function<? super T, String> contentConverter) {
        Objects.requireNonNull(contentConverter, "contentConverter");
        return ResponseConversionUtil.streamingFrom(contentStream, JsonTextSequences.sanitizeHeaders(headers), trailers, o -> JsonTextSequences.toHttpData(contentConverter, o), executor);
    }

    public static HttpResponse fromObject(@Nullable Object content) {
        return JsonTextSequences.fromObject(defaultHttpHeaders, content, HttpHeaders.of(), defaultMapper);
    }

    public static HttpResponse fromObject(ResponseHeaders headers, @Nullable Object content) {
        return JsonTextSequences.fromObject(headers, content, HttpHeaders.of(), defaultMapper);
    }

    public static HttpResponse fromObject(ResponseHeaders headers, @Nullable Object content, ObjectMapper mapper) {
        return JsonTextSequences.fromObject(headers, content, HttpHeaders.of(), mapper);
    }

    public static HttpResponse fromObject(ResponseHeaders headers, @Nullable Object content, HttpHeaders trailers, ObjectMapper mapper) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(mapper, "mapper");
        return HttpResponse.of(JsonTextSequences.sanitizeHeaders(headers), JsonTextSequences.toHttpData(mapper, content), trailers);
    }

    static <T> HttpResponse fromObject(ResponseHeaders headers, @Nullable T content, HttpHeaders trailers, Function<? super T, String> contentConverter) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(contentConverter, "contentConverter");
        return HttpResponse.of(JsonTextSequences.sanitizeHeaders(headers), JsonTextSequences.toHttpData(contentConverter, content), trailers);
    }

    private static ResponseHeaders sanitizeHeaders(ResponseHeaders headers) {
        if (headers == defaultHttpHeaders) {
            return headers;
        }
        return JsonTextSequences.ensureContentType(JsonTextSequences.ensureHttpStatus(headers));
    }

    static ResponseHeaders ensureHttpStatus(ResponseHeaders headers) {
        HttpStatus status = headers.status();
        if (status.equals(HttpStatus.OK)) {
            return headers;
        }
        if (!warnedStatusCode) {
            logger.warn("Overwriting the HTTP status code from '{}' to '{}' for JSON Text Sequences. Do not set an HTTP status code on the HttpHeaders when calling factory methods in '{}', or set '{}' if you want to specify its status code. Please refer to https://datatracker.ietf.org/doc/rfc7464/ for more information.", status, HttpStatus.OK, JsonTextSequences.class.getSimpleName(), HttpStatus.OK);
            warnedStatusCode = true;
        }
        return headers.toBuilder().status(HttpStatus.OK).build();
    }

    static ResponseHeaders ensureContentType(ResponseHeaders headers) {
        MediaType contentType = headers.contentType();
        if (contentType == null) {
            return headers.toBuilder().contentType(MediaType.JSON_SEQ).build();
        }
        if (contentType.is(MediaType.JSON_SEQ)) {
            return headers;
        }
        if (!warnedContentType) {
            logger.warn("Overwriting content-type from '{}' to '{}' for JSON Text Sequences. Do not set a content-type on the HttpHeaders when calling factory methods in '{}', or set '{}' if you want to specify its content-type. Please refer to https://datatracker.ietf.org/doc/rfc7464/ for more information.", contentType, MediaType.JSON_SEQ, JsonTextSequences.class.getSimpleName(), MediaType.JSON_SEQ);
            warnedContentType = true;
        }
        return headers.toBuilder().contentType(MediaType.JSON_SEQ).build();
    }

    private static HttpData toHttpData(ObjectMapper mapper, @Nullable Object value) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(30);
            mapper.writeValue(out, value);
            out.write(10);
            return HttpData.wrap(out.toByteArray());
        }
        catch (Exception e) {
            return (HttpData)Exceptions.throwUnsafely(e);
        }
    }

    private static <T> HttpData toHttpData(Function<? super T, String> contentConverter, @Nullable T value) {
        String content = contentConverter.apply(value);
        Objects.requireNonNull(content, "contentConverter.apply() returned null");
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        int contentLength = contentBytes.length;
        byte[] jsonText = new byte[contentLength + 2];
        jsonText[0] = 30;
        System.arraycopy(contentBytes, 0, jsonText, 1, contentLength);
        jsonText[contentLength + 1] = 10;
        return HttpData.wrap(jsonText);
    }

    private JsonTextSequences() {
    }

    static {
        defaultMapper = JacksonUtil.newDefaultObjectMapper();
        defaultHttpHeaders = ResponseHeaders.builder(HttpStatus.OK).contentType(MediaType.JSON_SEQ).build();
    }
}

