/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.server.DefaultRoutingContext;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.ServerConfig;
import io.netty.channel.Channel;

final class ServiceRouteUtil {
    static RoutingContext newRoutingContext(ServerConfig serverConfig, Channel channel, SessionProtocol sessionProtocol, RequestHeaders headers, RequestTarget reqTarget) {
        String hostname = ServiceRouteUtil.hostname(headers);
        int port = ChannelUtil.getPort(channel.localAddress(), 0);
        String originalPath = headers.path();
        RoutingStatus routingStatus = headers.method() == HttpMethod.OPTIONS ? (ArmeriaHttpUtil.isCorsPreflightRequest(headers) ? RoutingStatus.CORS_PREFLIGHT : ("*".equals(originalPath) ? RoutingStatus.OPTIONS : RoutingStatus.OK)) : RoutingStatus.OK;
        return DefaultRoutingContext.of(serverConfig.findVirtualHost(hostname, port), hostname, reqTarget, headers, routingStatus, sessionProtocol);
    }

    private static String hostname(RequestHeaders headers) {
        String authority = headers.authority();
        assert (authority != null);
        int hostnameColonIdx = authority.lastIndexOf(58);
        if (hostnameColonIdx < 0) {
            return authority;
        }
        return authority.substring(0, hostnameColonIdx);
    }

    private ServiceRouteUtil() {
    }
}

