/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.caffeine.cache;

import com.linecorp.armeria.internal.shaded.caffeine.cache.CacheLoader;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Node;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Pacer;
import com.linecorp.armeria.internal.shaded.caffeine.cache.SSMS;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Scheduler;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Ticker;
import com.linecorp.armeria.internal.shaded.caffeine.cache.WriteOrderDeque;

class SSMSW<K, V>
extends SSMS<K, V> {
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    SSMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
        super(builder, cacheLoader, async);
        this.ticker = builder.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        this.pacer = builder.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(builder.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
        this.expiresAfterWriteNanos = expiresAfterWriteNanos;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

