/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.AnnotatedService;
import com.linecorp.armeria.server.annotation.HttpResult;

final class HttpResultUtil {
    static ResponseHeaders buildResponseHeaders(ServiceRequestContext ctx, HttpResult<?> result) {
        ResponseHeadersBuilder builder;
        HttpHeaders customHeaders = result.headers();
        if (customHeaders instanceof ResponseHeaders) {
            builder = ((ResponseHeaders)customHeaders).toBuilder();
        } else {
            builder = ResponseHeaders.builder();
            builder.add((Iterable)customHeaders);
            if (!builder.contains(HttpHeaderNames.STATUS)) {
                AnnotatedService service = ctx.config().service().as(AnnotatedService.class);
                if (service != null) {
                    builder.status(service.defaultStatus());
                } else {
                    builder.status(HttpStatus.OK);
                }
            }
        }
        return HttpResultUtil.maybeAddContentType(ctx, builder).build();
    }

    private static ResponseHeadersBuilder maybeAddContentType(ServiceRequestContext ctx, ResponseHeadersBuilder builder) {
        if (builder.status().isContentAlwaysEmpty()) {
            return builder;
        }
        if (builder.contentType() != null) {
            return builder;
        }
        MediaType negotiatedResponseMediaType = ctx.negotiatedResponseMediaType();
        if (negotiatedResponseMediaType != null) {
            builder.contentType(negotiatedResponseMediaType);
        }
        return builder;
    }

    private HttpResultUtil() {
    }
}

