/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.RecordCondition;
import org.apache.skywalking.oap.server.core.query.type.Record;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.Service;

public interface IRecordsQueryDAO
extends Service {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Record> readRecordsDebuggable(RecordCondition condition, String valueColumnName, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: readRecords");
                span.setMsg("Condition: RecordCondition: " + condition + ", ValueColumnName: " + valueColumnName + ", Duration: " + duration);
            }
            List<Record> list = this.readRecords(condition, valueColumnName, duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    public List<Record> readRecords(RecordCondition var1, String var2, Duration var3) throws IOException;
}

