/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.continuous.storage;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingMonitorType;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingTargetType;
import org.apache.skywalking.oap.server.core.query.input.ContinuousProfilingPolicyCreation;
import org.apache.skywalking.oap.server.core.query.input.ContinuousProfilingPolicyItemCreation;
import org.apache.skywalking.oap.server.core.query.input.ContinuousProfilingPolicyTargetCreation;

public class ContinuousProfilingPolicyConfiguration {
    private static Gson GSON = new Gson();
    private Map<ContinuousProfilingTargetType, Map<ContinuousProfilingMonitorType, CheckItem>> targetCheckers = new HashMap<ContinuousProfilingTargetType, Map<ContinuousProfilingMonitorType, CheckItem>>();

    public String toJSON() {
        return GSON.toJson((Object)this);
    }

    public static ContinuousProfilingPolicyConfiguration buildFromRequest(ContinuousProfilingPolicyCreation request) {
        ContinuousProfilingPolicyConfiguration data = new ContinuousProfilingPolicyConfiguration();
        for (ContinuousProfilingPolicyTargetCreation target : request.getTargets()) {
            ContinuousProfilingTargetType targetType = target.getTargetType();
            Map items = data.targetCheckers.computeIfAbsent(targetType, k -> new HashMap());
            for (ContinuousProfilingPolicyItemCreation itemRequest : target.getCheckItems()) {
                CheckItem item = new CheckItem();
                item.setThreshold(itemRequest.getThreshold());
                item.setPeriod(itemRequest.getPeriod());
                item.setCount(itemRequest.getCount());
                item.setUriList(itemRequest.getUriList());
                item.setUriRegex(itemRequest.getUriRegex());
                items.put(itemRequest.getType(), item);
            }
        }
        return data;
    }

    public static ContinuousProfilingPolicyConfiguration parseFromJSON(String json) {
        return (ContinuousProfilingPolicyConfiguration)GSON.fromJson(json, ContinuousProfilingPolicyConfiguration.class);
    }

    @Generated
    public Map<ContinuousProfilingTargetType, Map<ContinuousProfilingMonitorType, CheckItem>> getTargetCheckers() {
        return this.targetCheckers;
    }

    @Generated
    public void setTargetCheckers(Map<ContinuousProfilingTargetType, Map<ContinuousProfilingMonitorType, CheckItem>> targetCheckers) {
        this.targetCheckers = targetCheckers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContinuousProfilingPolicyConfiguration)) {
            return false;
        }
        ContinuousProfilingPolicyConfiguration other = (ContinuousProfilingPolicyConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<ContinuousProfilingTargetType, Map<ContinuousProfilingMonitorType, CheckItem>> this$targetCheckers = this.getTargetCheckers();
        Map<ContinuousProfilingTargetType, Map<ContinuousProfilingMonitorType, CheckItem>> other$targetCheckers = other.getTargetCheckers();
        return !(this$targetCheckers == null ? other$targetCheckers != null : !((Object)this$targetCheckers).equals(other$targetCheckers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContinuousProfilingPolicyConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<ContinuousProfilingTargetType, Map<ContinuousProfilingMonitorType, CheckItem>> $targetCheckers = this.getTargetCheckers();
        result = result * 59 + ($targetCheckers == null ? 43 : ((Object)$targetCheckers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContinuousProfilingPolicyConfiguration(targetCheckers=" + this.getTargetCheckers() + ")";
    }

    public static class CheckItem {
        private String threshold;
        private int period;
        private int count;
        private List<String> uriList;
        private String uriRegex;

        @Generated
        public static CheckItemBuilder builder() {
            return new CheckItemBuilder();
        }

        @Generated
        public String getThreshold() {
            return this.threshold;
        }

        @Generated
        public int getPeriod() {
            return this.period;
        }

        @Generated
        public int getCount() {
            return this.count;
        }

        @Generated
        public List<String> getUriList() {
            return this.uriList;
        }

        @Generated
        public String getUriRegex() {
            return this.uriRegex;
        }

        @Generated
        public void setThreshold(String threshold) {
            this.threshold = threshold;
        }

        @Generated
        public void setPeriod(int period) {
            this.period = period;
        }

        @Generated
        public void setCount(int count) {
            this.count = count;
        }

        @Generated
        public void setUriList(List<String> uriList) {
            this.uriList = uriList;
        }

        @Generated
        public void setUriRegex(String uriRegex) {
            this.uriRegex = uriRegex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CheckItem)) {
                return false;
            }
            CheckItem other = (CheckItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPeriod() != other.getPeriod()) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            String this$threshold = this.getThreshold();
            String other$threshold = other.getThreshold();
            if (this$threshold == null ? other$threshold != null : !this$threshold.equals(other$threshold)) {
                return false;
            }
            List<String> this$uriList = this.getUriList();
            List<String> other$uriList = other.getUriList();
            if (this$uriList == null ? other$uriList != null : !((Object)this$uriList).equals(other$uriList)) {
                return false;
            }
            String this$uriRegex = this.getUriRegex();
            String other$uriRegex = other.getUriRegex();
            return !(this$uriRegex == null ? other$uriRegex != null : !this$uriRegex.equals(other$uriRegex));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CheckItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPeriod();
            result = result * 59 + this.getCount();
            String $threshold = this.getThreshold();
            result = result * 59 + ($threshold == null ? 43 : $threshold.hashCode());
            List<String> $uriList = this.getUriList();
            result = result * 59 + ($uriList == null ? 43 : ((Object)$uriList).hashCode());
            String $uriRegex = this.getUriRegex();
            result = result * 59 + ($uriRegex == null ? 43 : $uriRegex.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContinuousProfilingPolicyConfiguration.CheckItem(threshold=" + this.getThreshold() + ", period=" + this.getPeriod() + ", count=" + this.getCount() + ", uriList=" + this.getUriList() + ", uriRegex=" + this.getUriRegex() + ")";
        }

        @Generated
        public CheckItem() {
        }

        @Generated
        public CheckItem(String threshold, int period, int count, List<String> uriList, String uriRegex) {
            this.threshold = threshold;
            this.period = period;
            this.count = count;
            this.uriList = uriList;
            this.uriRegex = uriRegex;
        }

        @Generated
        public static class CheckItemBuilder {
            @Generated
            private String threshold;
            @Generated
            private int period;
            @Generated
            private int count;
            @Generated
            private List<String> uriList;
            @Generated
            private String uriRegex;

            @Generated
            CheckItemBuilder() {
            }

            @Generated
            public CheckItemBuilder threshold(String threshold) {
                this.threshold = threshold;
                return this;
            }

            @Generated
            public CheckItemBuilder period(int period) {
                this.period = period;
                return this;
            }

            @Generated
            public CheckItemBuilder count(int count) {
                this.count = count;
                return this;
            }

            @Generated
            public CheckItemBuilder uriList(List<String> uriList) {
                this.uriList = uriList;
                return this;
            }

            @Generated
            public CheckItemBuilder uriRegex(String uriRegex) {
                this.uriRegex = uriRegex;
                return this;
            }

            @Generated
            public CheckItem build() {
                return new CheckItem(this.threshold, this.period, this.count, this.uriList, this.uriRegex);
            }

            @Generated
            public String toString() {
                return "ContinuousProfilingPolicyConfiguration.CheckItem.CheckItemBuilder(threshold=" + this.threshold + ", period=" + this.period + ", count=" + this.count + ", uriList=" + this.uriList + ", uriRegex=" + this.uriRegex + ")";
            }
        }
    }
}

