/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;

public class TrendOp {
    public static ExpressionResult doTrendOp(ExpressionResult expResult, int opType, int trendRange, Step step) throws IllegalExpressionException {
        switch (opType) {
            case 35: {
                return TrendOp.calculateIncrease(expResult, trendRange);
            }
            case 36: {
                return TrendOp.calculateRate(expResult, trendRange, step);
            }
        }
        throw new IllegalExpressionException("Unsupported function.");
    }

    private static ExpressionResult calculateIncrease(ExpressionResult expResult, int trendRange) {
        expResult.getResults().forEach(resultValues -> {
            List mqeValues = resultValues.getValues();
            ArrayList<MQEValue> newMqeValues = new ArrayList<MQEValue>();
            for (int i = trendRange; i < mqeValues.size(); ++i) {
                MQEValue mqeValue = (MQEValue)mqeValues.get(i);
                if (mqeValue.isEmptyValue()) {
                    newMqeValues.add(mqeValue);
                    continue;
                }
                MQEValue newMqeValue = new MQEValue();
                newMqeValue.setId(mqeValue.getId());
                if (((MQEValue)mqeValues.get(i - trendRange)).isEmptyValue()) {
                    newMqeValue.setEmptyValue(true);
                    newMqeValues.add(newMqeValue);
                    continue;
                }
                newMqeValue.setEmptyValue(mqeValue.isEmptyValue());
                newMqeValue.setId(mqeValue.getId());
                newMqeValue.setTraceID(mqeValue.getTraceID());
                double newValue = mqeValue.getDoubleValue() - ((MQEValue)mqeValues.get(i - trendRange)).getDoubleValue();
                newMqeValue.setDoubleValue(newValue);
                newMqeValues.add(newMqeValue);
            }
            resultValues.setValues(newMqeValues);
        });
        return expResult;
    }

    private static ExpressionResult calculateRate(ExpressionResult expResult, int trendRange, Step step) {
        long rangeSeconds;
        ExpressionResult result = TrendOp.calculateIncrease(expResult, trendRange);
        switch (step) {
            case SECOND: {
                rangeSeconds = trendRange;
                break;
            }
            case MINUTE: {
                rangeSeconds = trendRange * 60;
                break;
            }
            case HOUR: {
                rangeSeconds = trendRange * 3600;
                break;
            }
            case DAY: {
                rangeSeconds = trendRange * 86400;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported step: " + step);
            }
        }
        result.getResults().forEach(resultValues -> resultValues.getValues().forEach(mqeValue -> {
            if (!mqeValue.isEmptyValue()) {
                double newValue = mqeValue.getDoubleValue() / (double)rangeSeconds;
                mqeValue.setDoubleValue(newValue);
            }
        }));
        return result;
    }
}

