/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.promql.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Path;
import com.linecorp.armeria.server.annotation.Post;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.oap.query.graphql.resolver.MetadataQueryV2;
import org.apache.skywalking.oap.query.promql.PromQLConfig;
import org.apache.skywalking.oap.query.promql.entity.ErrorType;
import org.apache.skywalking.oap.query.promql.entity.LabelName;
import org.apache.skywalking.oap.query.promql.entity.LabelValuePair;
import org.apache.skywalking.oap.query.promql.entity.MetricInfo;
import org.apache.skywalking.oap.query.promql.entity.MetricInstantData;
import org.apache.skywalking.oap.query.promql.entity.MetricMetadata;
import org.apache.skywalking.oap.query.promql.entity.MetricRangeData;
import org.apache.skywalking.oap.query.promql.entity.ResultStatus;
import org.apache.skywalking.oap.query.promql.entity.TimeValuePair;
import org.apache.skywalking.oap.query.promql.entity.response.BuildInfoRsp;
import org.apache.skywalking.oap.query.promql.entity.response.ExprQueryRsp;
import org.apache.skywalking.oap.query.promql.entity.response.LabelValuesQueryRsp;
import org.apache.skywalking.oap.query.promql.entity.response.LabelsQueryRsp;
import org.apache.skywalking.oap.query.promql.entity.response.MetadataQueryRsp;
import org.apache.skywalking.oap.query.promql.entity.response.MetricRspData;
import org.apache.skywalking.oap.query.promql.entity.response.MetricType;
import org.apache.skywalking.oap.query.promql.entity.response.QueryResponse;
import org.apache.skywalking.oap.query.promql.entity.response.ResultType;
import org.apache.skywalking.oap.query.promql.entity.response.ScalarRspData;
import org.apache.skywalking.oap.query.promql.entity.response.SeriesQueryRsp;
import org.apache.skywalking.oap.query.promql.rt.PromOpUtils;
import org.apache.skywalking.oap.query.promql.rt.PromQLExprQueryVisitor;
import org.apache.skywalking.oap.query.promql.rt.PromQLMatchVisitor;
import org.apache.skywalking.oap.query.promql.rt.exception.ParseErrorListener;
import org.apache.skywalking.oap.query.promql.rt.result.MatcherSetResult;
import org.apache.skywalking.oap.query.promql.rt.result.MetricsRangeResult;
import org.apache.skywalking.oap.query.promql.rt.result.ParseResult;
import org.apache.skywalking.oap.query.promql.rt.result.ScalarResult;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataLabel;
import org.apache.skywalking.oap.server.core.query.AggregationQueryService;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.MetricDefinition;
import org.apache.skywalking.oap.server.core.query.MetricsMetadataQueryService;
import org.apache.skywalking.oap.server.core.query.MetricsQueryService;
import org.apache.skywalking.oap.server.core.query.RecordQueryService;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.promql.rt.grammar.PromQLLexer;
import org.apache.skywalking.promql.rt.grammar.PromQLParser;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class PromQLApiHandler {
    private final MetadataQueryV2 metadataQuery;
    private final ModuleManager moduleManager;
    private final PromQLConfig config;
    private MetricsMetadataQueryService metricsMetadataQueryService;
    private MetricsQueryService metricsQueryService;
    private AggregationQueryService aggregationQueryService;
    private RecordQueryService recordQueryService;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public PromQLApiHandler(ModuleManager moduleManager, PromQLConfig config) {
        this.metadataQuery = new MetadataQueryV2(moduleManager);
        this.moduleManager = moduleManager;
        this.config = config;
    }

    private MetricsMetadataQueryService getMetricsMetadataQueryService() {
        if (this.metricsMetadataQueryService == null) {
            this.metricsMetadataQueryService = (MetricsMetadataQueryService)this.moduleManager.find("core").provider().getService(MetricsMetadataQueryService.class);
        }
        return this.metricsMetadataQueryService;
    }

    private MetricsQueryService getMetricsQueryService() {
        if (this.metricsQueryService == null) {
            this.metricsQueryService = (MetricsQueryService)this.moduleManager.find("core").provider().getService(MetricsQueryService.class);
        }
        return this.metricsQueryService;
    }

    private AggregationQueryService getAggregationQueryService() {
        if (this.aggregationQueryService == null) {
            this.aggregationQueryService = (AggregationQueryService)this.moduleManager.find("core").provider().getService(AggregationQueryService.class);
        }
        return this.aggregationQueryService;
    }

    private RecordQueryService getRecordQueryService() {
        if (this.recordQueryService == null) {
            this.recordQueryService = (RecordQueryService)this.moduleManager.find("core").provider().getService(RecordQueryService.class);
        }
        return this.recordQueryService;
    }

    @Get
    @Path(value="/api/v1/metadata")
    public HttpResponse metadata(@Param(value="limit") Optional<Integer> limit, @Param(value="metric") Optional<String> metric) throws JsonProcessingException {
        MetadataQueryRsp response = new MetadataQueryRsp();
        response.setStatus(ResultStatus.SUCCESS);
        String regex = metric.orElse("");
        List definitionList = this.getMetricsMetadataQueryService().listMetrics(regex);
        int inputLimit = limit.orElse(definitionList.size());
        int maxNum = Math.min(inputLimit, definitionList.size());
        for (int i = 0; i < maxNum; ++i) {
            ArrayList<MetricMetadata> metadataList = new ArrayList<MetricMetadata>();
            MetricMetadata metadata = new MetricMetadata(MetricType.GAUGE, "", "");
            metadataList.add(metadata);
            response.getData().put(((MetricDefinition)definitionList.get(i)).getName(), metadataList);
        }
        return this.jsonResponse(response);
    }

    @Get
    @Post
    @Path(value="/api/v1/labels")
    public HttpResponse labels(@Param(value="match[]") Optional<String> match, @Param(value="start") Optional<String> start, @Param(value="end") Optional<String> end) throws IOException {
        LabelsQueryRsp response = new LabelsQueryRsp();
        long endTS = System.currentTimeMillis();
        if (end.isPresent()) {
            endTS = PromQLApiHandler.formatTimestamp2Millis(end.get());
        }
        Duration duration = this.getDayDurationFromTimestamp(endTS);
        if (match.isPresent()) {
            MatcherSetResult parseResult;
            try {
                parseResult = this.getMatcherSetResult(match.get());
            }
            catch (ParseCancellationException e) {
                response.setStatus(ResultStatus.ERROR);
                response.setErrorType(ErrorType.BAD_DATA);
                response.setError(e.getMessage());
                return this.jsonResponse(response);
            }
            String metricName = parseResult.getMetricName();
            Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
            if (valueColumn.isPresent()) {
                ValueColumnMetadata.ValueColumn metaData = (ValueColumnMetadata.ValueColumn)valueColumn.get();
                Scope scope = Scope.Finder.valueOf((int)metaData.getScopeId());
                response.getData().addAll(this.buildLabelNames(scope, metaData));
                if (Column.ValueDataType.LABELED_VALUE == ((ValueColumnMetadata.ValueColumn)valueColumn.get()).getDataType()) {
                    List<MetricsValues> matchedMetrics = this.getMatcherMetricsValues(parseResult, duration);
                    response.getData().addAll(this.buildLabelNamesFromQuery(matchedMetrics));
                }
                if (metaData.isMultiIntValues()) {
                    response.getData().remove("_");
                }
            }
        } else {
            Arrays.stream(LabelName.values()).forEach(label -> response.getData().add(label.getLabel()));
        }
        response.setStatus(ResultStatus.SUCCESS);
        return this.jsonResponse(response);
    }

    @Get
    @Path(value="/api/v1/label/{label_name}/values")
    public HttpResponse labelValues(@Param(value="label_name") String labelName, @Param(value="match[]") Optional<String> match, @Param(value="start") Optional<String> start, @Param(value="end") Optional<String> end) throws IOException {
        LabelValuesQueryRsp response = new LabelValuesQueryRsp();
        response.setStatus(ResultStatus.SUCCESS);
        long endTS = System.currentTimeMillis();
        if (end.isPresent()) {
            endTS = PromQLApiHandler.formatTimestamp2Millis(end.get());
        }
        Duration duration = this.getDayDurationFromTimestamp(endTS);
        if (LabelName.NAME.getLabel().equals(labelName)) {
            this.getMetricsMetadataQueryService().listMetrics("").forEach(definition -> response.getData().add(definition.getName()));
            return this.jsonResponse(response);
        }
        if (LabelName.LAYER.getLabel().equals(labelName)) {
            for (Layer layer : Layer.values()) {
                response.getData().add(layer.name());
            }
            return this.jsonResponse(response);
        }
        if (LabelName.SCOPE.getLabel().equals(labelName)) {
            for (Scope scope : Scope.values()) {
                response.getData().add(scope.name());
            }
            return this.jsonResponse(response);
        }
        if (match.isPresent()) {
            MatcherSetResult parseResult;
            try {
                parseResult = this.getMatcherSetResult(match.get());
            }
            catch (ParseCancellationException e) {
                response.setStatus(ResultStatus.ERROR);
                response.setErrorType(ErrorType.BAD_DATA);
                response.setError(e.getMessage());
                return this.jsonResponse(response);
            }
            String metricName = parseResult.getMetricName();
            Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
            if (valueColumn.isPresent() && Column.ValueDataType.LABELED_VALUE == ((ValueColumnMetadata.ValueColumn)valueColumn.get()).getDataType()) {
                List<MetricsValues> matchedMetrics = this.getMatcherMetricsValues(parseResult, duration);
                response.getData().addAll(this.buildLabelValuesFromQuery(matchedMetrics, labelName));
            } else if (Objects.equals(metricName, "service_traffic")) {
                String serviceName = parseResult.getLabelMap().get(LabelName.SERVICE.getLabel());
                if (StringUtil.isNotBlank((String)serviceName)) {
                    Service service2 = (Service)this.metadataQuery.findService(serviceName).join();
                    response.getData().add(service2.getName());
                } else {
                    List services = (List)this.metadataQuery.listServices(parseResult.getLabelMap().get(LabelName.LAYER.getLabel())).join();
                    services.forEach(service -> response.getData().add(service.getName()));
                }
            } else if (Objects.equals(metricName, "instance_traffic")) {
                String serviceName = parseResult.getLabelMap().get(LabelName.SERVICE.getLabel());
                String layer = parseResult.getLabelMap().get(LabelName.LAYER.getLabel());
                List instances = (List)this.metadataQuery.listInstances(duration, IDManager.ServiceID.buildId((String)serviceName, (boolean)Layer.valueOf((String)layer).isNormal())).join();
                instances.forEach(instance -> response.getData().add(instance.getName()));
            } else if (Objects.equals(metricName, "endpoint_traffic")) {
                String serviceName = parseResult.getLabelMap().get(LabelName.SERVICE.getLabel());
                String layer = parseResult.getLabelMap().get(LabelName.LAYER.getLabel());
                String keyword = parseResult.getLabelMap().getOrDefault(LabelName.KEYWORD.getLabel(), "");
                String limit = parseResult.getLabelMap().getOrDefault(LabelName.LIMIT.getLabel(), "100");
                List endpoints = (List)this.metadataQuery.findEndpoint(keyword, IDManager.ServiceID.buildId((String)serviceName, (boolean)Layer.valueOf((String)layer).isNormal()), Integer.parseInt(limit), duration).join();
                endpoints.forEach(endpoint -> response.getData().add(endpoint.getName()));
            }
        }
        return this.jsonResponse(response);
    }

    @Get
    @Post
    @Path(value="/api/v1/series")
    public HttpResponse series(@Param(value="match[]") String match, @Param(value="start") String start, @Param(value="end") String end) throws IOException {
        MatcherSetResult parseResult;
        long startTS = PromQLApiHandler.formatTimestamp2Millis(start);
        long endTS = PromQLApiHandler.formatTimestamp2Millis(end);
        Duration duration = DurationUtils.timestamp2Duration((long)startTS, (long)endTS);
        SeriesQueryRsp response = new SeriesQueryRsp();
        try {
            parseResult = this.getMatcherSetResult(match);
        }
        catch (ParseCancellationException e) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError(e.getMessage());
            return this.jsonResponse(response);
        }
        String metricName = parseResult.getMetricName();
        Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
        if (valueColumn.isPresent()) {
            ValueColumnMetadata.ValueColumn metaData = (ValueColumnMetadata.ValueColumn)valueColumn.get();
            Scope scope = Scope.Finder.valueOf((int)metaData.getScopeId());
            Column.ValueDataType dataType = metaData.getDataType();
            response.getData().add(this.buildMetaMetricInfo(metricName, scope, dataType));
        } else if (Objects.equals(metricName, "service_traffic")) {
            String serviceName = parseResult.getLabelMap().get(LabelName.SERVICE.getLabel());
            if (StringUtil.isNotBlank((String)serviceName)) {
                Service service2 = (Service)this.metadataQuery.findService(serviceName).join();
                response.getData().add(this.buildMetricInfoFromTraffic(metricName, service2));
            } else {
                List services = (List)this.metadataQuery.listServices(parseResult.getLabelMap().get(LabelName.LAYER.getLabel())).join();
                services.forEach(service -> response.getData().add(this.buildMetricInfoFromTraffic(metricName, (Service)service)));
            }
        } else if (Objects.equals(metricName, "instance_traffic")) {
            String serviceName = parseResult.getLabelMap().get(LabelName.SERVICE.getLabel());
            String layer = parseResult.getLabelMap().get(LabelName.LAYER.getLabel());
            List instances = (List)this.metadataQuery.listInstances(duration, IDManager.ServiceID.buildId((String)serviceName, (boolean)Layer.valueOf((String)layer).isNormal())).join();
            instances.forEach(instance -> response.getData().add(this.buildMetricInfoFromTraffic(metricName, (ServiceInstance)instance)));
        } else if (Objects.equals(metricName, "endpoint_traffic")) {
            String serviceName = parseResult.getLabelMap().get(LabelName.SERVICE.getLabel());
            String layer = parseResult.getLabelMap().get(LabelName.LAYER.getLabel());
            String keyword = parseResult.getLabelMap().getOrDefault(LabelName.KEYWORD.getLabel(), "");
            String limit = parseResult.getLabelMap().getOrDefault(LabelName.LIMIT.getLabel(), "100");
            List endpoints = (List)this.metadataQuery.findEndpoint(keyword, IDManager.ServiceID.buildId((String)serviceName, (boolean)Layer.valueOf((String)layer).isNormal()), Integer.parseInt(limit), duration).join();
            endpoints.forEach(endpoint -> response.getData().add(this.buildMetricInfoFromTraffic(metricName, (Endpoint)endpoint)));
        }
        response.setStatus(ResultStatus.SUCCESS);
        return this.jsonResponse(response);
    }

    @Get
    @Post
    @Path(value="/api/v1/query")
    public HttpResponse query(@Param(value="query") String query, @Param(value="time") Optional<String> time, @Param(value="timeout") Optional<String> timeout) throws IOException {
        PromQLParser.ExpressionContext tree;
        long endTS = System.currentTimeMillis();
        if (time.isPresent()) {
            endTS = PromQLApiHandler.formatTimestamp2Millis(time.get());
        }
        long startTS = endTS - 120000L;
        Duration duration = DurationUtils.timestamp2Duration((long)startTS, (long)endTS);
        ExprQueryRsp response = new ExprQueryRsp();
        PromQLLexer lexer = new PromQLLexer((CharStream)CharStreams.fromString((String)query));
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        PromQLParser parser = new PromQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        try {
            tree = parser.expression();
        }
        catch (ParseCancellationException e) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError(e.getMessage());
            return this.jsonResponse(response);
        }
        PromQLExprQueryVisitor visitor = new PromQLExprQueryVisitor(this.getMetricsQueryService(), this.getRecordQueryService(), this.getAggregationQueryService(), duration, QueryType.INSTANT);
        ParseResult parseResult = (ParseResult)visitor.visit((ParseTree)tree);
        if (parseResult == null) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError("Bad expression, can not parse it.");
        } else if (StringUtil.isBlank((String)parseResult.getErrorInfo())) {
            if (parseResult.isRangeExpression()) {
                this.buildMatrixRsp(parseResult, response);
            } else {
                switch (parseResult.getResultType()) {
                    case METRICS_RANGE: {
                        this.buildVectorRsp(parseResult, response);
                        break;
                    }
                    case SCALAR: {
                        this.buildScalarRsp(parseResult, response);
                    }
                }
            }
        } else {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(parseResult.getErrorType());
            response.setError(parseResult.getErrorInfo());
        }
        return this.jsonResponse(response);
    }

    @Get
    @Post
    @Path(value="/api/v1/query_range")
    public HttpResponse query_range(@Param(value="query") String query, @Param(value="start") String start, @Param(value="end") String end, @Param(value="step") Optional<String> step, @Param(value="timeout") Optional<String> timeout) throws IOException {
        PromQLParser.ExpressionContext tree;
        long startTS = PromQLApiHandler.formatTimestamp2Millis(start);
        long endTS = PromQLApiHandler.formatTimestamp2Millis(end);
        Duration duration = DurationUtils.timestamp2Duration((long)startTS, (long)endTS);
        ExprQueryRsp response = new ExprQueryRsp();
        PromQLLexer lexer = new PromQLLexer((CharStream)CharStreams.fromString((String)query));
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        PromQLParser parser = new PromQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        try {
            tree = parser.expression();
        }
        catch (ParseCancellationException e) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError(e.getMessage());
            return this.jsonResponse(response);
        }
        PromQLExprQueryVisitor visitor = new PromQLExprQueryVisitor(this.getMetricsQueryService(), this.getRecordQueryService(), this.getAggregationQueryService(), duration, QueryType.RANGE);
        ParseResult parseResult = (ParseResult)visitor.visit((ParseTree)tree);
        if (parseResult == null) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError("Bad expression, can not parse it.");
        } else if (StringUtil.isBlank((String)parseResult.getErrorInfo())) {
            switch (parseResult.getResultType()) {
                case METRICS_RANGE: {
                    this.buildMatrixRsp(parseResult, response);
                    break;
                }
                case SCALAR: {
                    this.buildScalarMatrixRsp(duration, parseResult, response);
                }
            }
        } else {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(parseResult.getErrorType());
            response.setError(parseResult.getErrorInfo());
        }
        return this.jsonResponse(response);
    }

    @Get
    @Post
    @Path(value="/api/v1/status/buildinfo")
    public HttpResponse buildInfo() throws IOException {
        BuildInfoRsp buildInfoRsp = new BuildInfoRsp();
        buildInfoRsp.setStatus(ResultStatus.SUCCESS);
        buildInfoRsp.getData().setVersion(this.config.getBuildInfoVersion());
        buildInfoRsp.getData().setRevision(this.config.getBuildInfoRevision());
        buildInfoRsp.getData().setBranch(this.config.getBuildInfoBranch());
        buildInfoRsp.getData().setBuildUser(this.config.getBuildInfoBuildUser());
        buildInfoRsp.getData().setBuildDate(this.config.getBuildInfoBuildDate());
        buildInfoRsp.getData().setGoVersion(this.config.getBuildInfoGoVersion());
        return this.jsonResponse(buildInfoRsp);
    }

    private HttpResponse jsonResponse(QueryResponse response) throws JsonProcessingException {
        return HttpResponse.of((ResponseHeaders)ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(MediaType.JSON).build(), (HttpData)HttpData.ofUtf8((String)MAPPER.writeValueAsString((Object)response)));
    }

    private void buildVectorRsp(ParseResult parseResult, ExprQueryRsp response) {
        MetricRspData exprRspData = new MetricRspData();
        response.setData(exprRspData);
        exprRspData.setResultType(ResultType.VECTOR);
        MetricsRangeResult matrixResult = (MetricsRangeResult)parseResult;
        response.setStatus(ResultStatus.SUCCESS);
        matrixResult.getMetricDataList().forEach(rangData -> {
            List<TimeValuePair> values = rangData.getValues();
            if (values.size() > 0) {
                MetricInstantData instantData = new MetricInstantData();
                instantData.setValue(values.get(values.size() - 1));
                instantData.setMetric(rangData.getMetric());
                exprRspData.getResult().add(instantData);
            }
        });
    }

    private void buildScalarRsp(ParseResult parseResult, ExprQueryRsp response) {
        ScalarRspData scalarRspData = new ScalarRspData();
        response.setData(scalarRspData);
        scalarRspData.setResultType(ResultType.SCALAR);
        ScalarResult scalarResult = (ScalarResult)parseResult;
        response.setStatus(ResultStatus.SUCCESS);
        scalarRspData.setResult(new TimeValuePair(System.currentTimeMillis() / 1000L, PromOpUtils.formatDoubleValue(scalarResult.getValue())));
    }

    private void buildMatrixRsp(ParseResult parseResult, ExprQueryRsp response) {
        MetricRspData responseData = new MetricRspData();
        responseData.setResultType(ResultType.MATRIX);
        response.setData(responseData);
        MetricsRangeResult matrixResult = (MetricsRangeResult)parseResult;
        response.setStatus(ResultStatus.SUCCESS);
        responseData.getResult().addAll(matrixResult.getMetricDataList());
    }

    private void buildScalarMatrixRsp(Duration duration, ParseResult parseResult, ExprQueryRsp response) {
        MetricRspData responseData = new MetricRspData();
        responseData.setResultType(ResultType.MATRIX);
        response.setData(responseData);
        ScalarResult scalarResult = (ScalarResult)parseResult;
        response.setStatus(ResultStatus.SUCCESS);
        MetricRangeData metricData = new MetricRangeData();
        metricData.setValues(PromOpUtils.buildMatrixValues(duration, PromOpUtils.formatDoubleValue(scalarResult.getValue())));
        responseData.getResult().add(metricData);
    }

    private static long formatTimestamp2Millis(String timestamp) {
        long time;
        try {
            time = Double.valueOf(timestamp).longValue() * 1000L;
        }
        catch (NumberFormatException e) {
            time = ISODateTimeFormat.dateTime().parseMillis(timestamp);
        }
        return time;
    }

    private List<String> buildLabelNames(Scope scope, ValueColumnMetadata.ValueColumn metaData) {
        ArrayList<String> labelNames = new ArrayList<String>();
        labelNames.add(LabelName.LAYER.getLabel());
        labelNames.add(LabelName.SERVICE.getLabel());
        labelNames.add(LabelName.TOP_N.getLabel());
        labelNames.add(LabelName.ORDER.getLabel());
        if (metaData.isMultiIntValues()) {
            labelNames.add(LabelName.LABELS.getLabel());
            labelNames.add(LabelName.RELABELS.getLabel());
        }
        switch (scope) {
            case ServiceInstance: {
                labelNames.add(LabelName.SERVICE_INSTANCE.getLabel());
                labelNames.add(LabelName.PARENT_SERVICE.getLabel());
                break;
            }
            case Endpoint: {
                labelNames.add(LabelName.ENDPOINT.getLabel());
                labelNames.add(LabelName.PARENT_SERVICE.getLabel());
            }
        }
        return labelNames;
    }

    private List<String> buildLabelNamesFromQuery(List<MetricsValues> metricsValues) {
        LinkedHashSet labelNames = new LinkedHashSet();
        metricsValues.forEach(metricsValue -> {
            DataLabel dataLabel = new DataLabel();
            dataLabel.put(metricsValue.getLabel());
            labelNames.addAll(dataLabel.keySet());
        });
        return Arrays.asList(labelNames.toArray(new String[0]));
    }

    private List<String> buildLabelValuesFromQuery(List<MetricsValues> metricsValues, String labelName) {
        LinkedHashSet labelValues = new LinkedHashSet();
        metricsValues.forEach(metricsValue -> {
            DataLabel dataLabel = new DataLabel();
            dataLabel.put(metricsValue.getLabel());
            labelValues.add((String)dataLabel.get((Object)labelName));
        });
        return Arrays.asList(labelValues.toArray(new String[0]));
    }

    private MetricInfo buildMetaMetricInfo(String metricName, Scope scope, Column.ValueDataType dataType) {
        MetricInfo metricInfo = new MetricInfo(metricName);
        metricInfo.getLabels().add(new LabelValuePair(LabelName.LAYER.getLabel(), ""));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.TOP_N.getLabel(), ""));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.ORDER.getLabel(), ""));
        if (Column.ValueDataType.LABELED_VALUE == dataType) {
            metricInfo.getLabels().add(new LabelValuePair(LabelName.LABELS.getLabel(), ""));
            metricInfo.getLabels().add(new LabelValuePair(LabelName.RELABELS.getLabel(), ""));
        }
        switch (scope) {
            case Service: {
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE.getLabel(), Scope.Service.name()));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE.getLabel(), ""));
                break;
            }
            case ServiceInstance: {
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE.getLabel(), Scope.ServiceInstance.name()));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE.getLabel(), ""));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE_INSTANCE.getLabel(), ""));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.PARENT_SERVICE.getLabel(), ""));
                break;
            }
            case Endpoint: {
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE.getLabel(), Scope.Endpoint.name()));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE.getLabel(), ""));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.ENDPOINT.getLabel(), ""));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.PARENT_SERVICE.getLabel(), ""));
            }
        }
        return metricInfo;
    }

    private MetricInfo buildMetricInfoFromTraffic(String metricName, Service service) {
        MetricInfo metricInfo = new MetricInfo(metricName);
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE.getLabel(), service.getName()));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE.getLabel(), Scope.Service.name()));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.LAYER.getLabel(), (String)service.getLayers().iterator().next()));
        return metricInfo;
    }

    private MetricInfo buildMetricInfoFromTraffic(String metricName, ServiceInstance instance) {
        MetricInfo metricInfo = new MetricInfo(metricName);
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE_INSTANCE.getLabel(), instance.getName()));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE.getLabel(), Scope.ServiceInstance.name()));
        return metricInfo;
    }

    private MetricInfo buildMetricInfoFromTraffic(String metricName, Endpoint endpoint) {
        MetricInfo metricInfo = new MetricInfo(metricName);
        metricInfo.getLabels().add(new LabelValuePair(LabelName.ENDPOINT.getLabel(), endpoint.getName()));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE.getLabel(), Scope.Endpoint.name()));
        return metricInfo;
    }

    private Duration getDayDurationFromTimestamp(long timeTS) {
        Duration duration = new Duration();
        DateTime dt = new DateTime(timeTS);
        duration.setStep(Step.DAY);
        duration.setStart(dt.toString(DurationUtils.YYYY_MM_DD));
        duration.setEnd(dt.toString(DurationUtils.YYYY_MM_DD));
        return duration;
    }

    private MatcherSetResult getMatcherSetResult(String matchString) {
        PromQLLexer lexer = new PromQLLexer((CharStream)CharStreams.fromString((String)matchString));
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        PromQLParser parser = new PromQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        PromQLParser.ExpressionContext tree = parser.expression();
        PromQLMatchVisitor visitor = new PromQLMatchVisitor();
        return (MatcherSetResult)visitor.visit((ParseTree)tree);
    }

    private List<MetricsValues> getMatcherMetricsValues(MatcherSetResult parseResult, Duration duration) throws IOException {
        String metricName = parseResult.getMetricName();
        List matchLabels = parseResult.getLabelMap().entrySet().stream().map(entry -> {
            KeyValue keyValue = new KeyValue();
            keyValue.setKey((String)entry.getKey());
            keyValue.setValue((String)entry.getValue());
            return keyValue;
        }).collect(Collectors.toList());
        return this.getMetricsQueryService().readLabeledMetricsValuesWithoutEntity(metricName, matchLabels, duration);
    }

    public static enum QueryType {
        INSTANT,
        RANGE;

    }
}

