/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.promql.entity;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize
public enum LabelName {
    NAME("__name__"),
    LAYER("layer"),
    SCOPE("scope"),
    SERVICE("service"),
    SERVICE_INSTANCE("service_instance"),
    ENDPOINT("endpoint"),
    LABELS("labels"),
    RELABELS("relabels"),
    LABEL("label"),
    PARENT_SERVICE("parent_service"),
    TOP_N("top_n"),
    ORDER("order"),
    RECORD("record"),
    LIMIT("limit"),
    KEYWORD("keyword"),
    DEST_SERVICE("dest_service"),
    DEST_LAYER("dest_layer"),
    DEST_SERVICE_INSTANCE("dest_service_instance"),
    DEST_ENDPOINT("dest_endpoint");

    final String label;
    private static final Map<String, LabelName> DICTIONARY;

    private LabelName(String label) {
        this.label = label;
    }

    public static LabelName labelOf(String label) {
        LabelName labelName = DICTIONARY.get(label);
        if (labelName == null) {
            throw new IllegalArgumentException("Unknown Label Name: " + label);
        }
        return labelName;
    }

    public static boolean isLabelName(String label) {
        return DICTIONARY.containsKey(label);
    }

    @JsonValue
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    static {
        DICTIONARY = new HashMap<String, LabelName>();
        Arrays.stream(LabelName.values()).forEach(l -> DICTIONARY.put(l.label, (LabelName)((Object)l)));
    }
}

