/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util.prometheus.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;

public class Histogram
extends Metric {
    private long sampleCount;
    private double sampleSum;
    private Map<Double, Long> buckets;

    public Histogram(String name, Map<String, String> labels, long sampleCount, double sampleSum, Map<Double, Long> buckets, long timestamp) {
        super(name, labels, timestamp);
        this.getLabels().remove("le");
        this.sampleCount = sampleCount;
        this.sampleSum = sampleSum;
        this.buckets = buckets;
    }

    @Override
    public Metric sum(Metric m) {
        Histogram h = (Histogram)m;
        this.buckets = Stream.concat(this.getBuckets().entrySet().stream(), h.getBuckets().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Long::sum, TreeMap::new));
        this.sampleSum += h.sampleSum;
        this.sampleCount += h.sampleCount;
        return this;
    }

    @Override
    public Double value() {
        return this.getSampleSum() * 1000.0 / (double)this.getSampleCount();
    }

    @Generated
    public static HistogramBuilder builder() {
        return new HistogramBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Histogram)) {
            return false;
        }
        Histogram other = (Histogram)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSampleCount() != other.getSampleCount()) {
            return false;
        }
        if (Double.compare(this.getSampleSum(), other.getSampleSum()) != 0) {
            return false;
        }
        Map<Double, Long> this$buckets = this.getBuckets();
        Map<Double, Long> other$buckets = other.getBuckets();
        return !(this$buckets == null ? other$buckets != null : !((Object)this$buckets).equals(other$buckets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Histogram;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $sampleCount = this.getSampleCount();
        result = result * 59 + (int)($sampleCount >>> 32 ^ $sampleCount);
        long $sampleSum = Double.doubleToLongBits(this.getSampleSum());
        result = result * 59 + (int)($sampleSum >>> 32 ^ $sampleSum);
        Map<Double, Long> $buckets = this.getBuckets();
        result = result * 59 + ($buckets == null ? 43 : ((Object)$buckets).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Histogram(super=" + super.toString() + ", sampleCount=" + this.getSampleCount() + ", sampleSum=" + this.getSampleSum() + ", buckets=" + this.getBuckets() + ")";
    }

    @Generated
    public long getSampleCount() {
        return this.sampleCount;
    }

    @Generated
    public double getSampleSum() {
        return this.sampleSum;
    }

    @Generated
    public Map<Double, Long> getBuckets() {
        return this.buckets;
    }

    @Generated
    public static class HistogramBuilder {
        @Generated
        private String name;
        @Generated
        private ArrayList<String> labels$key;
        @Generated
        private ArrayList<String> labels$value;
        @Generated
        private long sampleCount;
        @Generated
        private double sampleSum;
        @Generated
        private ArrayList<Double> buckets$key;
        @Generated
        private ArrayList<Long> buckets$value;
        @Generated
        private long timestamp;

        @Generated
        HistogramBuilder() {
        }

        @Generated
        public HistogramBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public HistogramBuilder label(String labelKey, String labelValue) {
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            this.labels$key.add(labelKey);
            this.labels$value.add(labelValue);
            return this;
        }

        @Generated
        public HistogramBuilder labels(Map<? extends String, ? extends String> labels) {
            if (labels == null) {
                throw new NullPointerException("labels cannot be null");
            }
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : labels.entrySet()) {
                this.labels$key.add($lombokEntry.getKey());
                this.labels$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public HistogramBuilder clearLabels() {
            if (this.labels$key != null) {
                this.labels$key.clear();
                this.labels$value.clear();
            }
            return this;
        }

        @Generated
        public HistogramBuilder sampleCount(long sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        @Generated
        public HistogramBuilder sampleSum(double sampleSum) {
            this.sampleSum = sampleSum;
            return this;
        }

        @Generated
        public HistogramBuilder bucket(Double bucketKey, Long bucketValue) {
            if (this.buckets$key == null) {
                this.buckets$key = new ArrayList();
                this.buckets$value = new ArrayList();
            }
            this.buckets$key.add(bucketKey);
            this.buckets$value.add(bucketValue);
            return this;
        }

        @Generated
        public HistogramBuilder buckets(Map<? extends Double, ? extends Long> buckets) {
            if (buckets == null) {
                throw new NullPointerException("buckets cannot be null");
            }
            if (this.buckets$key == null) {
                this.buckets$key = new ArrayList();
                this.buckets$value = new ArrayList();
            }
            for (Map.Entry<? extends Double, ? extends Long> $lombokEntry : buckets.entrySet()) {
                this.buckets$key.add($lombokEntry.getKey());
                this.buckets$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public HistogramBuilder clearBuckets() {
            if (this.buckets$key != null) {
                this.buckets$key.clear();
                this.buckets$value.clear();
            }
            return this;
        }

        @Generated
        public HistogramBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public Histogram build() {
            Map<Double, Long> buckets;
            Map<String, String> labels;
            switch (this.labels$key == null ? 0 : this.labels$key.size()) {
                case 0: {
                    labels = Collections.emptyMap();
                    break;
                }
                case 1: {
                    labels = Collections.singletonMap(this.labels$key.get(0), this.labels$value.get(0));
                    break;
                }
                default: {
                    labels = new LinkedHashMap(this.labels$key.size() < 0x40000000 ? 1 + this.labels$key.size() + (this.labels$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.labels$key.size(); ++$i) {
                        labels.put(this.labels$key.get($i), this.labels$value.get($i));
                    }
                    labels = Collections.unmodifiableMap(labels);
                }
            }
            switch (this.buckets$key == null ? 0 : this.buckets$key.size()) {
                case 0: {
                    buckets = Collections.emptyMap();
                    break;
                }
                case 1: {
                    buckets = Collections.singletonMap(this.buckets$key.get(0), this.buckets$value.get(0));
                    break;
                }
                default: {
                    buckets = new LinkedHashMap(this.buckets$key.size() < 0x40000000 ? 1 + this.buckets$key.size() + (this.buckets$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.buckets$key.size(); ++$i) {
                        buckets.put(this.buckets$key.get($i), this.buckets$value.get($i));
                    }
                    buckets = Collections.unmodifiableMap(buckets);
                }
            }
            return new Histogram(this.name, labels, this.sampleCount, this.sampleSum, buckets, this.timestamp);
        }

        @Generated
        public String toString() {
            return "Histogram.HistogramBuilder(name=" + this.name + ", labels$key=" + this.labels$key + ", labels$value=" + this.labels$value + ", sampleCount=" + this.sampleCount + ", sampleSum=" + this.sampleSum + ", buckets$key=" + this.buckets$key + ", buckets$value=" + this.buckets$value + ", timestamp=" + this.timestamp + ")";
        }
    }
}

