/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.UnloggedExceptionsReporter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultUnloggedExceptionsReporter
implements UnloggedExceptionsReporter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUnloggedExceptionsReporter.class);
    private static final AtomicIntegerFieldUpdater<DefaultUnloggedExceptionsReporter> scheduledUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultUnloggedExceptionsReporter.class, "scheduled");
    private final long intervalMillis;
    private final Counter micrometerCounter;
    private final LongAdder counter;
    private long lastExceptionsCount;
    private volatile int scheduled;
    @Nullable
    private ScheduledFuture<?> reportingTaskFuture;
    @Nullable
    private Throwable thrownException;

    DefaultUnloggedExceptionsReporter(MeterRegistry meterRegistry, long intervalMillis) {
        this.intervalMillis = intervalMillis;
        this.micrometerCounter = meterRegistry.counter("armeria.server.exceptions.unlogged", new String[0]);
        this.counter = new LongAdder();
    }

    @Override
    public void report(Throwable cause) {
        if (this.reportingTaskFuture == null && scheduledUpdater.compareAndSet(this, 0, 1)) {
            this.reportingTaskFuture = CommonPools.workerGroup().next().scheduleAtFixedRate(this::reportException, this.intervalMillis, this.intervalMillis, TimeUnit.MILLISECONDS);
        }
        if (this.thrownException == null) {
            this.thrownException = cause;
        }
        this.micrometerCounter.increment();
        this.counter.increment();
    }

    @Override
    public void serverStarting(Server server) throws Exception {
    }

    @Override
    public void serverStarted(Server server) throws Exception {
    }

    @Override
    public void serverStopping(Server server) throws Exception {
    }

    @Override
    public void serverStopped(Server server) throws Exception {
        if (this.reportingTaskFuture == null) {
            return;
        }
        this.reportingTaskFuture.cancel(true);
        this.reportingTaskFuture = null;
    }

    private void reportException() {
        long totalExceptionsCount = this.counter.sum();
        long newExceptionsCount = totalExceptionsCount - this.lastExceptionsCount;
        if (newExceptionsCount == 0L) {
            return;
        }
        Throwable exception = this.thrownException;
        if (exception != null) {
            logger.warn("Observed {} exception(s) that didn't reach a LoggingService in the last {}. Please consider adding a LoggingService as the outermost decorator to get detailed error logs. One of the thrown exceptions:", new Object[]{newExceptionsCount, TextFormatter.elapsed(this.intervalMillis, TimeUnit.MILLISECONDS), exception});
            this.thrownException = null;
        } else {
            logger.warn("Observed {} exception(s) that didn't reach a LoggingService in the last {}. Please consider adding a LoggingService as the outermost decorator to get detailed error logs.", (Object)newExceptionsCount, (Object)TextFormatter.elapsed(this.intervalMillis, TimeUnit.MILLISECONDS));
        }
        this.lastExceptionsCount = totalExceptionsCount;
    }
}

