/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.floats;

import com.linecorp.armeria.internal.shaded.fastutil.SafeMath;
import com.linecorp.armeria.internal.shaded.fastutil.Size64;
import com.linecorp.armeria.internal.shaded.fastutil.floats.FloatIterable;
import com.linecorp.armeria.internal.shaded.fastutil.floats.FloatIterator;
import com.linecorp.armeria.internal.shaded.fastutil.floats.FloatPredicate;
import com.linecorp.armeria.internal.shaded.fastutil.floats.FloatSpliterator;
import com.linecorp.armeria.internal.shaded.fastutil.floats.FloatSpliterators;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface FloatCollection
extends FloatIterable,
Collection<Float> {
    @Override
    public FloatIterator iterator();

    @Override
    default public FloatSpliterator spliterator() {
        return FloatSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(float var1);

    public boolean contains(float var1);

    public boolean rem(float var1);

    @Override
    @Deprecated
    default public boolean add(Float key) {
        return this.add(key.floatValue());
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains(((Float)key).floatValue());
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem(((Float)key).floatValue());
    }

    public float[] toFloatArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Float> filter) {
        return this.removeIf(filter instanceof FloatPredicate ? (FloatPredicate)filter : key -> filter.test(Float.valueOf(SafeMath.safeDoubleToFloat(key))));
    }

    default public boolean removeIf(FloatPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        FloatIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextFloat())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public Stream<Float> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Float> parallelStream() {
        return Collection.super.parallelStream();
    }
}

