/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.mceliece;

import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra.GoppaCode;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2m;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class McElieceCCA2PrivateKeyParameters
extends McElieceCCA2KeyParameters {
    private int n;
    private int k;
    private GF2mField field;
    private PolynomialGF2mSmallM goppaPoly;
    private Permutation p;
    private GF2Matrix h;
    private PolynomialGF2mSmallM[] qInv;

    public McElieceCCA2PrivateKeyParameters(int n, int n2, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, Permutation permutation, String string) {
        this(n, n2, gF2mField, polynomialGF2mSmallM, GoppaCode.createCanonicalCheckMatrix(gF2mField, polynomialGF2mSmallM), permutation, string);
    }

    public McElieceCCA2PrivateKeyParameters(int n, int n2, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, GF2Matrix gF2Matrix, Permutation permutation, String string) {
        super(true, string);
        this.n = n;
        this.k = n2;
        this.field = gF2mField;
        this.goppaPoly = polynomialGF2mSmallM;
        this.h = gF2Matrix;
        this.p = permutation;
        PolynomialRingGF2m polynomialRingGF2m = new PolynomialRingGF2m(gF2mField, polynomialGF2mSmallM);
        this.qInv = polynomialRingGF2m.getSquareRootMatrix();
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public GF2mField getField() {
        return this.field;
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.goppaPoly;
    }

    public Permutation getP() {
        return this.p;
    }

    public GF2Matrix getH() {
        return this.h;
    }
}

