/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

final class CountingSampler<T>
implements Sampler<T> {
    private final AtomicInteger counter = new AtomicInteger();
    final BitSet sampleDecisions;
    private final int percent;

    static <T> Sampler<T> create(float probability) {
        int percent = (int)(probability * 100.0f);
        Preconditions.checkArgument(percent >= 0 && percent <= 100, "probability: %s (expected: 0.0 <= probability <= 1.0)", (Object)Float.valueOf(probability));
        if (percent == 0) {
            return Sampler.never();
        }
        if (percent == 100) {
            return Sampler.always();
        }
        return new CountingSampler<T>(percent);
    }

    CountingSampler(int percent) {
        this(percent, new Random());
    }

    CountingSampler(int percent, Random random) {
        this.sampleDecisions = CountingSampler.randomBitSet(100, percent, random);
        this.percent = percent;
    }

    @Override
    public boolean isSampled(Object ignored) {
        return this.sampleDecisions.get(CountingSampler.mod(this.counter.getAndIncrement(), 100));
    }

    public String toString() {
        return "random=" + (double)this.percent / 100.0;
    }

    static int mod(int dividend, int divisor) {
        int result = dividend % divisor;
        return result >= 0 ? result : divisor + result;
    }

    static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }
}

