/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.CacheControl;
import com.linecorp.armeria.common.ClientCacheControlBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class ClientCacheControl
extends CacheControl {
    public static final ClientCacheControl EMPTY = ClientCacheControl.builder().build();
    public static final ClientCacheControl FORCE_NETWORK = ClientCacheControl.builder().noCache().build();
    public static final ClientCacheControl FORCE_CACHE = ClientCacheControl.builder().onlyIfCached().maxStaleSeconds(Integer.MAX_VALUE).build();
    private static final Map<String, BiConsumer<ClientCacheControlBuilder, String>> DIRECTIVES = ImmutableMap.builder().put("no-cache", (b, v) -> b.noCache()).put("no-store", (b, v) -> b.noStore()).put("no-transform", (b, v) -> b.noTransform()).put("max-age", (b, v) -> {
        long maxAgeSeconds = ArmeriaHttpUtil.parseDirectiveValueAsSeconds(v);
        if (maxAgeSeconds >= 0L) {
            b.maxAgeSeconds(maxAgeSeconds);
        }
    }).put("only-if-cached", (b, v) -> b.onlyIfCached()).put("max-stale", (b, v) -> {
        if (v == null) {
            b.maxStale();
        } else {
            long maxStaleSeconds = ArmeriaHttpUtil.parseDirectiveValueAsSeconds(v);
            if (maxStaleSeconds >= 0L) {
                b.maxStaleSeconds(maxStaleSeconds);
            }
        }
    }).put("min-fresh", (b, v) -> {
        long minFreshSeconds = ArmeriaHttpUtil.parseDirectiveValueAsSeconds(v);
        if (minFreshSeconds >= 0L) {
            b.minFreshSeconds(minFreshSeconds);
        }
    }).put("stale-while-revalidate", (b, v) -> {
        long staleWhileRevalidateSeconds = ArmeriaHttpUtil.parseDirectiveValueAsSeconds(v);
        if (staleWhileRevalidateSeconds >= 0L) {
            b.staleWhileRevalidateSeconds(staleWhileRevalidateSeconds);
        }
    }).put("stale-if-error", (b, v) -> {
        long staleIfErrorSeconds = ArmeriaHttpUtil.parseDirectiveValueAsSeconds(v);
        if (staleIfErrorSeconds >= 0L) {
            b.staleIfErrorSeconds(staleIfErrorSeconds);
        }
    }).build();
    static final long UNSPECIFIED_MAX_STALE = -2L;
    private final boolean onlyIfCached;
    final long maxStaleSeconds;
    private final long minFreshSeconds;
    private final long staleWhileRevalidateSeconds;
    private final long staleIfErrorSeconds;
    @Nullable
    private String headerValue;

    public static ClientCacheControl parse(String ... directives) {
        return ClientCacheControl.parse(ImmutableList.copyOf(Objects.requireNonNull(directives, "directives")));
    }

    public static ClientCacheControl parse(Iterable<String> directives) {
        Objects.requireNonNull(directives, "directives");
        ClientCacheControlBuilder builder = ClientCacheControl.builder();
        for (String d : directives) {
            ArmeriaHttpUtil.parseDirectives(d, (name, value) -> {
                BiConsumer<ClientCacheControlBuilder, String> action = DIRECTIVES.get(name);
                if (action != null) {
                    action.accept(builder, (String)value);
                }
            });
        }
        return builder.build();
    }

    public static ClientCacheControlBuilder builder() {
        return new ClientCacheControlBuilder();
    }

    ClientCacheControl(boolean noCache, boolean noStore, boolean noTransform, long maxAgeSeconds, boolean onlyIfCached, long maxStaleSeconds, long minFreshSeconds, long staleWhileRevalidateSeconds, long staleIfErrorSeconds) {
        super(noCache, noStore, noTransform, maxAgeSeconds);
        this.onlyIfCached = onlyIfCached;
        this.maxStaleSeconds = maxStaleSeconds;
        this.minFreshSeconds = minFreshSeconds;
        this.staleWhileRevalidateSeconds = staleWhileRevalidateSeconds;
        this.staleIfErrorSeconds = staleIfErrorSeconds;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && !this.onlyIfCached && !this.hasMaxStale() && this.minFreshSeconds < 0L && this.staleWhileRevalidateSeconds < 0L && this.staleIfErrorSeconds < 0L;
    }

    public boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public boolean hasMaxStale() {
        return this.maxStaleSeconds >= 0L || this.maxStaleSeconds == -2L;
    }

    public long maxStaleSeconds() {
        return this.maxStaleSeconds < 0L ? -1L : this.maxStaleSeconds;
    }

    public long minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public long staleWhileRevalidateSeconds() {
        return this.staleWhileRevalidateSeconds;
    }

    public long staleIfErrorSeconds() {
        return this.staleIfErrorSeconds;
    }

    @Override
    public ClientCacheControlBuilder toBuilder() {
        return new ClientCacheControlBuilder(this);
    }

    @Override
    public String asHeaderValue() {
        if (this.headerValue != null) {
            return this.headerValue;
        }
        StringBuilder buf = this.newHeaderValueBuffer();
        if (this.onlyIfCached) {
            buf.append(", only-if-cached");
        }
        if (this.maxStaleSeconds >= 0L) {
            buf.append(", max-stale=").append(this.maxStaleSeconds);
        } else if (this.maxStaleSeconds == -2L) {
            buf.append(", max-stale");
        }
        if (this.minFreshSeconds >= 0L) {
            buf.append(", min-fresh=").append(this.minFreshSeconds);
        }
        if (this.staleWhileRevalidateSeconds >= 0L) {
            buf.append(", stale-while-revalidate=").append(this.staleWhileRevalidateSeconds);
        }
        if (this.staleIfErrorSeconds >= 0L) {
            buf.append(", stale-if-error=").append(this.staleIfErrorSeconds);
        }
        if (buf.length() == 0) {
            this.headerValue = "";
            return "";
        }
        this.headerValue = buf.substring(2);
        return this.headerValue;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (!super.equals(o)) {
            return false;
        }
        assert (o != null);
        ClientCacheControl that = (ClientCacheControl)o;
        return this.onlyIfCached == that.onlyIfCached && this.maxStaleSeconds == that.maxStaleSeconds && this.minFreshSeconds == that.minFreshSeconds && this.staleWhileRevalidateSeconds == that.staleWhileRevalidateSeconds && this.staleIfErrorSeconds == that.staleIfErrorSeconds;
    }

    @Override
    public int hashCode() {
        return ((((super.hashCode() * 31 + (this.onlyIfCached ? 1 : 0)) * 31 + (int)(this.maxStaleSeconds ^ this.maxStaleSeconds >>> 32)) * 31 + (int)(this.minFreshSeconds ^ this.minFreshSeconds >>> 32)) * 31 + (int)(this.staleWhileRevalidateSeconds ^ this.staleWhileRevalidateSeconds >>> 32)) * 31 + (int)(this.staleIfErrorSeconds ^ this.staleIfErrorSeconds >>> 32);
    }
}

