/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FetchingConfigWatcherRegister
extends ConfigWatcherRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FetchingConfigWatcherRegister.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private final Register singleConfigChangeWatcherRegister = new Register();
    private final Register groupConfigChangeWatcherRegister = new Register();
    private volatile boolean isStarted = false;
    private final long syncPeriod;

    public FetchingConfigWatcherRegister() {
        this(60L);
    }

    public FetchingConfigWatcherRegister(long syncPeriod) {
        this.syncPeriod = syncPeriod;
    }

    @Override
    public synchronized void registerConfigChangeWatcher(ConfigChangeWatcher watcher) {
        if (this.isStarted) {
            throw new IllegalStateException("Config Register has been started. Can't register new watcher.");
        }
        ConfigWatcherRegister.WatcherHolder holder = new ConfigWatcherRegister.WatcherHolder(watcher);
        if (this.singleConfigChangeWatcherRegister.containsKey(holder.getKey()) || this.groupConfigChangeWatcherRegister.containsKey(holder.getKey())) {
            throw new IllegalStateException("Duplicate register, watcher=" + watcher);
        }
        switch (holder.getWatcher().getWatchType()) {
            case SINGLE: {
                this.singleConfigChangeWatcherRegister.put(holder.getKey(), holder);
                break;
            }
            case GROUP: {
                this.groupConfigChangeWatcherRegister.put(holder.getKey(), holder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected watch type of ConfigChangeWatcher " + watcher.toString());
            }
        }
    }

    @Override
    public void start() {
        this.isStarted = true;
        log.info("Current configurations after the bootstrap sync." + LINE_SEPARATOR + this.singleConfigChangeWatcherRegister.toString());
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)new RunnableWithExceptionProtection(this::configSync, t -> log.error("Sync config center error.", t)), 0L, this.syncPeriod, TimeUnit.SECONDS);
    }

    void configSync() {
        this.singleConfigsSync();
        this.groupConfigsSync();
    }

    private void singleConfigsSync() {
        Optional<ConfigTable> configTable = this.readConfig(this.singleConfigChangeWatcherRegister.keys());
        configTable.ifPresent(config -> {
            config.getItems().forEach(item -> {
                String itemName = item.getName();
                ConfigWatcherRegister.WatcherHolder holder = this.singleConfigChangeWatcherRegister.get(itemName);
                if (holder == null) {
                    log.warn("Config {} from configuration center, doesn't match any WatchType.SINGLE watcher, ignore.", (Object)itemName);
                    return;
                }
                ConfigChangeWatcher watcher = holder.getWatcher();
                this.notifySingleValue(watcher, (ConfigTable.ConfigItem)item);
            });
            if (log.isTraceEnabled()) {
                log.trace("Current configurations after the sync." + LINE_SEPARATOR + this.singleConfigChangeWatcherRegister.toString());
            }
        });
    }

    private void groupConfigsSync() {
        Optional<GroupConfigTable> groupConfigTable = this.readGroupConfig(this.groupConfigChangeWatcherRegister.keys());
        groupConfigTable.ifPresent(config -> {
            config.getGroupItems().forEach(groupConfigItems -> {
                String groupConfigItemName = groupConfigItems.getName();
                ConfigWatcherRegister.WatcherHolder holder = this.groupConfigChangeWatcherRegister.get(groupConfigItemName);
                if (holder == null) {
                    log.warn("Config {} from configuration center, doesn't match any WatchType.GROUP watcher, ignore.", (Object)groupConfigItemName);
                    return;
                }
                GroupConfigChangeWatcher watcher = (GroupConfigChangeWatcher)holder.getWatcher();
                this.notifyGroupValues(watcher, (GroupConfigTable.GroupConfigItems)groupConfigItems);
            });
            if (log.isTraceEnabled()) {
                log.trace("Current configurations after the sync." + LINE_SEPARATOR + this.groupConfigChangeWatcherRegister.toString());
            }
        });
    }

    public abstract Optional<ConfigTable> readConfig(Set<String> var1);

    public abstract Optional<GroupConfigTable> readGroupConfig(Set<String> var1);

    @Generated
    public Register getGroupConfigChangeWatcherRegister() {
        return this.groupConfigChangeWatcherRegister;
    }

    static class Register {
        private Map<String, ConfigWatcherRegister.WatcherHolder> register = new HashMap<String, ConfigWatcherRegister.WatcherHolder>();

        Register() {
        }

        private boolean containsKey(String key) {
            return this.register.containsKey(key);
        }

        private void put(String key, ConfigWatcherRegister.WatcherHolder holder) {
            this.register.put(key, holder);
        }

        public ConfigWatcherRegister.WatcherHolder get(String name) {
            return this.register.get(name);
        }

        public Set<String> keys() {
            return this.register.keySet();
        }

        public String toString() {
            StringBuilder registerTableDescription = new StringBuilder();
            registerTableDescription.append("Following dynamic config items are available.").append(LINE_SEPARATOR);
            registerTableDescription.append("---------------------------------------------").append(LINE_SEPARATOR);
            this.register.forEach((key, holder) -> {
                ConfigChangeWatcher watcher = holder.getWatcher();
                registerTableDescription.append("key:").append((String)key).append("    module:").append(watcher.getModule()).append("    provider:").append(watcher.getProvider().name());
                if (watcher.watchType.equals((Object)ConfigChangeWatcher.WatchType.GROUP)) {
                    GroupConfigChangeWatcher groupWatcher = (GroupConfigChangeWatcher)watcher;
                    registerTableDescription.append("    groupItems(current):").append(groupWatcher.groupItems());
                } else {
                    registerTableDescription.append("    value(current):").append(watcher.value());
                }
                registerTableDescription.append(LINE_SEPARATOR);
            });
            return registerTableDescription.toString();
        }
    }
}

