/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.decorators.BrowserPerfDataDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.BrowserPerfDataSourceBuilder;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.PerfDataAnalysisListener;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.PerfDataListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserPerfDataAnalysisListener
implements PerfDataAnalysisListener<BrowserPerfDataDecorator> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrowserPerfDataAnalysisListener.class);
    private final SourceReceiver sourceReceiver;
    private final BrowserPerfDataSourceBuilder sourceBuilder;

    public BrowserPerfDataAnalysisListener(SourceReceiver sourceReceiver, NamingControl namingControl) {
        this.sourceReceiver = sourceReceiver;
        this.sourceBuilder = new BrowserPerfDataSourceBuilder(namingControl);
    }

    @Override
    public void build() {
        this.sourceReceiver.receive((ISource)this.sourceBuilder.toBrowserAppTraffic());
        this.sourceReceiver.receive((ISource)this.sourceBuilder.toBrowserAppSingleVersionTraffic());
        this.sourceReceiver.receive((ISource)this.sourceBuilder.toBrowserAppPageTraffic());
        this.sourceReceiver.receive((ISource)this.sourceBuilder.toBrowserAppPagePerf());
    }

    @Override
    public void parse(BrowserPerfDataDecorator decorator) {
        this.sourceBuilder.setService(decorator.getService());
        this.sourceBuilder.setServiceVersion(decorator.getServiceVersion());
        this.sourceBuilder.setPatePath(decorator.getPagePath());
        this.sourceBuilder.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)decorator.getTime()));
        this.sourceBuilder.setRedirectTime(decorator.getRedirectTime());
        this.sourceBuilder.setDnsTime(decorator.getDnsTime());
        this.sourceBuilder.setTtfbTime(decorator.getTtfbTime());
        this.sourceBuilder.setTcpTime(decorator.getTcpTime());
        this.sourceBuilder.setTransTime(decorator.getTransTime());
        this.sourceBuilder.setDomAnalysisTime(decorator.getDomAnalysisTime());
        this.sourceBuilder.setFptTime(decorator.getFptTime());
        this.sourceBuilder.setDomReadyTime(decorator.getDomReadyTime());
        this.sourceBuilder.setLoadPageTime(decorator.getLoadPageTime());
        this.sourceBuilder.setResTime(decorator.getResTime());
        this.sourceBuilder.setSslTime(decorator.getSslTime());
        this.sourceBuilder.setTtlTime(decorator.getTtlTime());
        this.sourceBuilder.setFirstPackTime(decorator.getFirstPackTime());
        this.sourceBuilder.setFmpTime(decorator.getFmpTime());
    }

    public static class Factory
    implements PerfDataListenerFactory<BrowserPerfDataDecorator> {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public PerfDataAnalysisListener<BrowserPerfDataDecorator> create(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            return new BrowserPerfDataAnalysisListener(this.sourceReceiver, this.namingControl);
        }
    }
}

