/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.ZabbixMetrics;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixProtocolType;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixRequest;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZabbixProtocolHandler
extends SimpleChannelInboundHandler<ZabbixRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZabbixProtocolHandler.class);
    private final ZabbixMetrics metrics;

    public ZabbixProtocolHandler(ZabbixMetrics metrics) {
        this.metrics = metrics;
    }

    public void channelRead0(ChannelHandlerContext ctx, ZabbixRequest msg) {
        if (msg.getType() == ZabbixProtocolType.ACTIVE_CHECKS) {
            ZabbixResponse response = new ZabbixResponse();
            response.setType(msg.getType());
            String hostName = msg.getActiveChecks().getHostName();
            response.setActiveChecks(Optional.of(this.metrics.getAllMonitorMetricNames(hostName)).map(s -> s.stream().map(key -> ZabbixResponse.ActiveChecks.builder().delay(60).lastlogsize(0).key((String)key).mtime(0).build()).collect(Collectors.toList())).orElse(Collections.emptyList()));
            ctx.writeAndFlush((Object)response);
        } else {
            ZabbixMetrics.ConvertStatics convertStatics;
            ZabbixResponse response = new ZabbixResponse();
            response.setType(msg.getType());
            try {
                convertStatics = this.metrics.convertMetrics(msg.getAgentDataList());
            }
            catch (Exception e) {
                log.warn("Convert the Zabbix metrics error", (Throwable)e);
                convertStatics = ZabbixMetrics.ConvertStatics.builder().total(1).failed(1).build();
            }
            response.setAgentData(ZabbixResponse.AgentData.builder().info(String.format("processed: %d; failed: %d; total: %d; seconds spent: %f", convertStatics.getSuccess(), convertStatics.getFailed(), convertStatics.getTotal(), convertStatics.getUseTime())).build());
            ctx.writeAndFlush((Object)response);
        }
    }
}

