/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.debug;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import lombok.Generated;
import org.apache.skywalking.oap.query.debug.StatusQueryExceptionHandler;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClientManager;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExceptionHandler(value=StatusQueryExceptionHandler.class)
public class ClusterStatusQueryHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterStatusQueryHandler.class);
    private final ModuleManager moduleManager;
    private RemoteClientManager remoteClientManager;

    public ClusterStatusQueryHandler(ModuleManager manager) {
        this.moduleManager = manager;
    }

    private RemoteClientManager getRemoteClientManager() {
        if (this.remoteClientManager == null) {
            this.remoteClientManager = (RemoteClientManager)this.moduleManager.find("core").provider().getService(RemoteClientManager.class);
        }
        return this.remoteClientManager;
    }

    @Get(value="/status/cluster/nodes")
    public HttpResponse buildClusterNodeList(HttpRequest request) {
        JsonObject clusterInfo = new JsonObject();
        JsonArray nodeList = new JsonArray();
        clusterInfo.add("nodes", (JsonElement)nodeList);
        this.getRemoteClientManager().getRemoteClient().stream().map(c -> {
            Address address = c.getAddress();
            JsonObject node = new JsonObject();
            node.addProperty("host", address.getHost());
            node.addProperty("port", (Number)address.getPort());
            node.addProperty("isSelf", Boolean.valueOf(address.isSelf()));
            return node;
        }).forEach(arg_0 -> ((JsonArray)nodeList).add(arg_0));
        return HttpResponse.of((MediaType)MediaType.JSON_UTF_8, (String)clusterInfo.toString());
    }
}

